# Installation et Configuration

## Étapes d'installation

### 1. Exécuter les migrations
```bash
php artisan migrate
```

### 2. Créer le lien symbolique pour le storage
```bash
php artisan storage:link
```

### 3. Créer l'administrateur
```bash
php artisan db:seed --class=AdminSeeder
```

### 4. Lancer le serveur
```bash
php artisan serve
```

## Comptes de test

### Admin
- Email: `admin@example.com`
- Password: `password`
- Accès: `/admin/dashboard`

### Provider (à créer via l'admin)
- L'admin peut créer des providers depuis `/admin/providers/create`
- Les providers peuvent ensuite se connecter et accéder à `/provider/dashboard`

## Routes principales

### Admin
- `/admin/dashboard` - Dashboard admin
- `/admin/providers` - Liste des providers
- `/admin/providers/create` - Créer un provider
- `/admin/providers/{uuid}/edit` - Modifier un provider

### Provider
- `/provider/dashboard` - Dashboard provider
- `/provider/profile` - Modifier son profil

## Architecture

### Middlewares
- `admin` - Vérifie que l'utilisateur est admin
- `provider` - Vérifie que l'utilisateur est provider

### Modèles
- `User` - Utilisateurs (admin + provider)
- `Provider` - Profil prestataire

### Relations
- User hasOne Provider
- Provider belongsTo User

### UUID
- Tous les modèles génèrent automatiquement un UUID à la création
- Les routes publiques utilisent UUID (pas l'ID)
- Préparation pour le mode hors-ligne (V2)

### Sync Status
- Champ `sync_status` dans providers
- Valeurs: 'pending', 'synced', 'conflict'
- Préparation pour la synchronisation offline
