📘 README – Plateforme Prestataires & Services

(SaaS – Version 1 + Préparation Mode Hors-Ligne Version 2)

📝 Description générale du projet

Cette application est une plateforme de gestion pour prestataires offrant des services à domicile ou en déplacement (ex : massages, coaching, assistance, soins, etc.).

Elle permet au prestataire de gérer :

ses services et tarifs

ses rendez-vous

ses clients

ses encaissements

ses dépenses

ses factures

son calendrier (sans créneaux prédéfinis)

la configuration complète de son activité

La version actuelle (V1) fonctionne en ligne, mais toute l’architecture a été conçue pour être compatible avec un mode hors-ligne (V2) via un système de synchronisation.

Technologies principales :

Laravel 12

Breeze

TailwindCSS

MySQL

UUID + ID auto-increment

Préparation PWA + IndexedDB pour V2

📂 Architecture Fonctionnelle – Version 1 (online)
1. Authentification

Inscription prestataire

Login

Mot de passe oublié

Sécurisé avec Laravel Breeze

2. Module Prestataire

C’est le cœur du système.
Un prestataire ne peut pas être ajouté ou supprimé par lui-même : seul le super-admin SaaS le peut.

2.1 Profil du prestataire

Contient :

nom / prénom

téléphone

email

adresse facultative

information de déplacement

info fiscale (matricule fiscal, raison sociale → utilisé pour les factures)

photo de profil

2.2 Services (types de service)

Le prestataire gère ici ses services :

nom du service

description optionnelle

prix (modifiable à tout moment)

⚠ Pas de durée imposée → pour rester flexible.
⚠ Le prix au moment de chaque rendez-vous est dupliqué dans la table appointments (price_snapshot) pour éviter les incohérences après modification des tarifs.

2.3 Paramètres généraux

Ancien module séparé → fusionné avec module prestataire.

Contient :

langues

devise

info fiscale

options du calendrier

préférences d'affichage

3. Module Clients

Le prestataire crée et gère ses clients :

Champs :

nom / prénom

téléphone

adresse optionnelle

notes internes

historique des rendez-vous

total payé

Pas de système de réservation par le client → tout est fait par le prestataire.

4. Module Rendez-vous (Appointments)
Structure générale

Le prestataire crée des rendez-vous manuellement.

Un rendez-vous contient :

client_id

service_id

price_snapshot (prix du service au moment du rendez-vous)

date + heure de début

notes internes

Particularités :

❌ Pas de créneaux prédéfinis

Le calendrier est libre : le prestataire choisit n’importe quelle heure

Les cellules réservées sont bloquées → pas de chevauchement

En mode hors-ligne : la réservation se fait localement et sera synchronisée ensuite.

5. Module Finances
5.1 Encaissements

Le prestataire enregistre ses paiements.

Un encaissement contient :

client

montant

méthode de paiement (espèces, carte, virement, etc.)

date

description

⚠ L’encaissement n’est pas lié obligatoirement à une séance →
Un prestataire peut encaisser après X séances.

5.2 Dépenses

Le prestataire saisit ses dépenses :

Une dépense contient :

type de dépense

montant

date

description

justificatif (photo)

5.3 Types de dépenses

Liste personnalisable (ex : transport, matériel, location, etc.)

6. Module Factures

Rattaché au module Finances.

Une facture contient :

client

liste des prestations

total

TVA si activée

info fiscale du prestataire

PDF téléchargeable

7. Tableau de bord

Un dashboard affiche :

total rendez-vous

total clients

total encaissé

total dépenses

bénéfice

top services

top clients

🛢 Schéma technique – Base de données MySQL
Tables principales
providers

Prestataires.

services

Services + tarifs.

clients

Clients du prestataire.

appointments

Rendez-vous + price_snapshot.

payments

Encaissements.

expenses

Dépenses.

expense_types

Catégories de dépenses.

invoices

Factures.

invoice_items

Lignes de facture.

Clés identifiants

Chaque table a :

id (INT AUTO_INCREMENT) → performant pour jointures

uuid (CHAR(36)) → utilisé plus tard pour la synchronisation hors-ligne
→ Universel, non séquentiel, non devinable.

📡 Architecture Mode Hors-Ligne – Version 2 (préparée dans V1)

Même si V1 est 100% online, tout est conçu pour V2.

🔹 1. Données à synchroniser

Les tables suivantes seront disponibles hors-ligne :

clients

services

rendez-vous

encaissements

dépenses

types de dépenses

Le prestataire pourra :

créer / modifier / supprimer hors-ligne

le navigateur stocke tout dans IndexedDB

quand la connexion revient : synchronisation via uuid

conflits gérés par timestamps

🔹 2. Règles de synchronisation
Identifiant utilisé pour la synchronisation :

✔ uuid
❌ jamais id

Stratégie :

Si en local mais pas sur serveur → upload

Si sur serveur mais pas en local → download

Si modifié des deux côtés → règle : "la modification la plus récente gagne"

Documents volumineux :

photos factures

justificatifs

→ stockés en local via File System Access API puis upload différé.

🧱 Technologies recommandées

Backend :

Laravel 12

MySQL

Breeze

Policies + Gates pour sécurité

UUID (ramassage via trait HasUuids)

Frontend :

Blade

TailwindCSS

Alpine.js

FullCalendar (ou similaire)

Offline (V2) :

IndexedDB

Service Workers

Manifest.json

File System Access API

Background Sync

🚀 Roadmap
✔ Version 1 (online)

Authentification

Prestataire

Services

Clients

Rendez-vous

Encaissements

Dépenses

Factures

Dashboard

Style mobile-first

🔜 Version 2 (offline)

PWA

IndexedDB

Cache API

Synchronisation automatique

Gestion des conflits

File upload en différé

🚀 Version 3

Application mobile native (Flutter ou React Native)

Paiements en ligne

Notifications push