<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use Carbon\Carbon;
use Illuminate\Http\Request;

class CalendarController extends Controller
{
    public function index(Request $request)
    {
        $date = $request->get('date', now()->format('Y-m-d'));
        $selectedDate = Carbon::parse($date);
        
        $appointments = Appointment::with(['client', 'service'])
            ->where('provider_id', auth()->user()->provider->id)
            ->whereDate('start_time', $selectedDate)
            ->orderBy('start_time')
            ->get();

        return view('calendar.index', compact('appointments', 'selectedDate'));
    }

    public function getAppointments(Request $request)
    {
        $start = Carbon::parse($request->get('start'));
        $end = Carbon::parse($request->get('end'));
        
        $appointments = Appointment::with(['client', 'service'])
            ->where('provider_id', auth()->user()->provider->id)
            ->whereBetween('start_time', [$start, $end])
            ->get()
            ->map(function ($appointment) {
                return [
                    'id' => $appointment->id,
                    'title' => $appointment->service->name,
                    'start' => $appointment->start_time->toISOString(),
                    'end' => $appointment->end_time->toISOString(),
                    'backgroundColor' => $this->getStatusColor($appointment->status),
                    'borderColor' => $this->getStatusColor($appointment->status),
                ];
            });

        return response()->json($appointments);
    }

    private function getStatusColor($status): string
    {
        return match($status) {
            Appointment::STATUS_LATE => '#dc2626',
            Appointment::STATUS_COMPLETE => '#16a34a',
            Appointment::STATUS_IN_PROGRESS => '#ea580c',
            Appointment::STATUS_SCHEDULED => '#2563eb',
            default => '#6b7280'
        };
    }
}