<?php

namespace App\Http\Controllers\Provider;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateFiscalSettingsRequest;
use App\Http\Requests\UpdateGeneralSettingsRequest;

class SettingsController extends Controller
{
    /**
     * Show the fiscal settings form.
     */
    public function editFiscal()
    {
        $provider = auth()->user()->provider;
        
        return view('provider.settings.fiscal', compact('provider'));
    }

    /**
     * Update the fiscal settings.
     */
    public function updateFiscal(UpdateFiscalSettingsRequest $request)
    {
        $provider = auth()->user()->provider;
        
        $provider->update($request->validated());

        return redirect()->route('provider.settings.fiscal.edit')
            ->with('success', 'Informations fiscales mises à jour avec succès.');
    }

    /**
     * Show the general settings form.
     */
    public function editGeneral()
    {
        $provider = auth()->user()->provider;
        
        return view('provider.settings.general', compact('provider'));
    }

    /**
     * Update the general settings.
     */
    public function updateGeneral(UpdateGeneralSettingsRequest $request)
    {
        $provider = auth()->user()->provider;
        $data = $request->validated();
        
        // Séparer les données par catégorie
        $generalSettings = [
            'language' => !empty($data['language']) ? $data['language'] : null,
            'timezone' => !empty($data['timezone']) ? $data['timezone'] : null,
            'default_currency' => !empty($data['default_currency']) ? $data['default_currency'] : null,
            'first_day_of_week' => isset($data['first_day_of_week']) && $data['first_day_of_week'] !== '' ? $data['first_day_of_week'] : null,
            'default_calendar_view' => !empty($data['default_calendar_view']) ? $data['default_calendar_view'] : null,
        ];
        
        $calendarSettings = [
            'days_off' => $data['days_off'] ?? [],
            'slot_duration_minutes' => !empty($data['slot_duration_minutes']) ? $data['slot_duration_minutes'] : null,
        ];
        
        $billingSettings = [
            'invoice_prefix' => !empty($data['invoice_prefix']) ? $data['invoice_prefix'] : null,
            'invoice_footer' => !empty($data['invoice_footer']) ? $data['invoice_footer'] : null,
            'show_tax_id_on_invoice' => $data['show_tax_id_on_invoice'] ?? false,
            'default_tax_rate' => !empty($data['default_tax_rate']) ? $data['default_tax_rate'] : null,
        ];
        
        // Mettre à jour les settings
        $settings = $provider->settings ?? [];
        $settings['general'] = array_merge($settings['general'] ?? [], $generalSettings);
        $settings['calendar'] = array_merge($settings['calendar'] ?? [], $calendarSettings);
        $settings['billing'] = array_merge($settings['billing'] ?? [], $billingSettings);
        
        $provider->update(['settings' => $settings]);

        return redirect()->route('provider.settings.general.edit')
            ->with('success', 'Paramètres généraux mis à jour avec succès.');
    }
}