<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateFiscalSettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->role === 'provider';
    }

    public function rules(): array
    {
        return [
            'legal_name' => 'nullable|string|max:191',
            'tax_id' => 'nullable|string|max:50',
        ];
    }
}