<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateGeneralSettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->role === 'provider';
    }

    public function rules(): array
    {
        return [
            'language' => 'nullable|string|max:5',
            'timezone' => 'nullable|string|max:191',
            'default_currency' => 'nullable|string|in:TND,EUR,USD',
            'first_day_of_week' => 'nullable|in:0,1',
            'default_calendar_view' => 'nullable|string|in:day,week,month',
            'days_off' => 'nullable|array',
            'days_off.*' => 'integer|between:0,6',
            'slot_duration_minutes' => 'nullable|in:15,30,60,120',
            'invoice_prefix' => 'nullable|string|max:20',
            'invoice_footer' => 'nullable|string',
            'show_tax_id_on_invoice' => 'nullable|boolean',
            'default_tax_rate' => 'nullable|numeric|min:0|max:100',
        ];
    }


}