<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->unique()->index();
            $table->unsignedBigInteger('provider_id')->index();
            $table->string('name', 150);
            $table->text('description')->nullable();
            $table->unsignedSmallInteger('duration_minutes');
            $table->decimal('base_price', 10, 2);
            $table->char('currency', 3)->default('TND');
            $table->string('color', 20)->nullable();
            $table->boolean('is_active')->default(true);
            $table->json('settings')->nullable();
            $table->enum('sync_status', ['pending', 'synced', 'conflict'])->default('synced');
            $table->timestamps();
            $table->softDeletes();
            
            // Index pour les performances
            $table->index(['provider_id', 'is_active']);
            $table->index(['provider_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
