<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->unique()->index();
            $table->unsignedBigInteger('provider_id')->index();
            $table->unsignedBigInteger('expense_type_id')->index();
            $table->unsignedBigInteger('client_id')->nullable()->index();
            $table->decimal('amount', 10, 2);
            $table->char('currency', 3)->default('TND');
            $table->date('expense_date');
            $table->enum('payment_method', ['cash', 'card', 'bank_transfer', 'other'])->default('cash');
            $table->string('reference', 150)->nullable();
            $table->text('notes')->nullable();
            $table->enum('sync_status', ['pending', 'synced', 'conflict'])->default('synced');
            $table->softDeletes();
            $table->timestamps();
            
            $table->foreign('provider_id')->references('id')->on('providers');
            $table->foreign('expense_type_id')->references('id')->on('expense_types');
            $table->foreign('client_id')->references('id')->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};