<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->unique()->index();
            $table->unsignedBigInteger('provider_id')->index();
            $table->unsignedBigInteger('client_id')->nullable()->index();
            $table->unsignedBigInteger('service_id')->nullable()->index();
            $table->dateTime('start_time');
            $table->dateTime('end_time');
            $table->decimal('price_at_booking', 10, 2)->nullable();
            $table->char('currency', 3)->default('TND');
            $table->enum('status', ['scheduled', 'completed', 'canceled', 'no_show'])->default('scheduled');
            $table->text('notes')->nullable();
            $table->enum('sync_status', ['pending', 'synced', 'conflict'])->default('synced');
            $table->softDeletes();
            $table->timestamps();
            
            $table->foreign('provider_id')->references('id')->on('providers');
            $table->foreign('client_id')->references('id')->on('clients');
            $table->foreign('service_id')->references('id')->on('services');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};