<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->unique();
            
            $table->unsignedBigInteger('provider_id')->index();
            $table->unsignedBigInteger('client_id')->nullable()->index();
            $table->unsignedBigInteger('appointment_id')->nullable()->index();
            
            $table->decimal('amount', 10, 2);
            $table->char('currency', 3)->default('TND');
            $table->date('payment_date');
            $table->enum('method', ['cash', 'card', 'bank_transfer', 'other'])->default('cash');
            $table->string('reference', 150)->nullable();
            $table->text('notes')->nullable();
            
            $table->enum('sync_status', ['pending', 'synced', 'conflict'])->default('synced');
            $table->timestamps();
            
            $table->foreign('provider_id')->references('id')->on('providers');
            $table->foreign('client_id')->references('id')->on('clients');
            $table->foreign('appointment_id')->references('id')->on('appointments');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
