<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $prefix = config('database.connections.mysql.prefix', '');
        Schema::create($prefix . 'suppliers', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('provider_id')->constrained($prefix . 'providers')->onDelete('cascade');
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->text('address')->nullable();
            $table->string('tax_id')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index('provider_id');
        });
    }

    public function down(): void
    {
        $prefix = config('database.connections.mysql.prefix', '');
        Schema::dropIfExists($prefix . 'suppliers');
    }
};
