<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            // Supprimer la contrainte de clé étrangère et la colonne client_id
            $table->dropForeign(['client_id']);
            $table->dropColumn('client_id');
            
            // Ajouter la colonne supplier_id
            $table->unsignedBigInteger('supplier_id')->nullable()->after('expense_type_id');
            $table->foreign('supplier_id')->references('id')->on('suppliers')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            // Supprimer la contrainte de clé étrangère et la colonne supplier_id
            $table->dropForeign(['supplier_id']);
            $table->dropColumn('supplier_id');
            
            // Restaurer la colonne client_id
            $table->unsignedBigInteger('client_id')->nullable()->after('expense_type_id');
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('set null');
        });
    }
};
