<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $prefix = config('database.connections.mysql.prefix', '');
        Schema::table($prefix . 'suppliers', function (Blueprint $table) {
            $table->boolean('is_active')->default(true)->after('notes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $prefix = config('database.connections.mysql.prefix', '');
        Schema::table($prefix . 'suppliers', function (Blueprint $table) {
            $table->dropColumn('is_active');
        });
    }
};
