<?php

namespace Database\Seeders;

use App\Models\Appointment;
use App\Models\Client;
use App\Models\Provider;
use App\Models\Service;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class CalendarTestSeeder extends Seeder
{
    public function run(): void
    {
        // Récupérer le premier provider ou en créer un
        $provider = Provider::first();
        if (!$provider) {
            $user = User::create([
                'name' => 'Test Provider',
                'email' => 'provider@test.com',
                'password' => bcrypt('password'),
                'role' => 'provider',
                'is_active' => true,
            ]);

            $provider = Provider::create([
                'user_id' => $user->id,
                'first_name' => 'John',
                'last_name' => 'Doe',
                'phone' => '+33123456789',
                'email' => 'provider@test.com',
            ]);
        }

        // Créer des services
        $services = [
            ['name' => 'Massage à domicile', 'base_price' => 80.00],
            ['name' => 'Coaching sportif', 'base_price' => 60.00],
            ['name' => 'Soins esthétiques', 'base_price' => 120.00],
            ['name' => 'Réparation toiture', 'base_price' => 150.00],
        ];

        $createdServices = [];
        foreach ($services as $serviceData) {
            $createdServices[] = Service::create([
                'provider_id' => $provider->id,
                'name' => $serviceData['name'],
                'base_price' => $serviceData['base_price'],
                'duration_minutes' => 60,
                'currency' => 'EUR',
            ]);
        }

        // Créer des clients
        $clients = [
            ['first_name' => 'Selena', 'last_name' => 'Martin', 'address' => '1400 E 4th St'],
            ['first_name' => 'Javier', 'last_name' => 'Bonat', 'address' => '1134 Highway'],
            ['first_name' => 'Katrina', 'last_name' => 'Leary', 'address' => '34 Green Terrace Cv'],
            ['first_name' => 'Martin', 'last_name' => 'Alan', 'address' => '3517 N Hills Drive'],
        ];

        $createdClients = [];
        foreach ($clients as $clientData) {
            $createdClients[] = Client::create([
                'provider_id' => $provider->id,
                'first_name' => $clientData['first_name'],
                'last_name' => $clientData['last_name'],
                'address' => $clientData['address'],
                'phone' => '+33' . rand(100000000, 999999999),
            ]);
        }

        // Créer des rendez-vous pour aujourd'hui
        $today = Carbon::today();
        
        $appointments = [
            [
                'client' => $createdClients[0],
                'service' => $createdServices[3],
                'start_time' => $today->copy()->setTime(9, 0),
                'end_time' => $today->copy()->setTime(10, 0),
                'status' => Appointment::STATUS_LATE,
            ],
            [
                'client' => $createdClients[1],
                'service' => $createdServices[3],
                'start_time' => $today->copy()->setTime(10, 0),
                'end_time' => $today->copy()->setTime(13, 0),
                'status' => Appointment::STATUS_COMPLETE,
            ],
            [
                'client' => $createdClients[2],
                'service' => $createdServices[0],
                'start_time' => $today->copy()->setTime(13, 0),
                'end_time' => $today->copy()->setTime(14, 30),
                'status' => Appointment::STATUS_IN_PROGRESS,
            ],
            [
                'client' => $createdClients[3],
                'service' => $createdServices[3],
                'start_time' => $today->copy()->setTime(15, 0),
                'end_time' => $today->copy()->setTime(18, 0),
                'status' => Appointment::STATUS_SCHEDULED,
            ],
        ];

        foreach ($appointments as $appointmentData) {
            Appointment::create([
                'provider_id' => $provider->id,
                'client_id' => $appointmentData['client']->id,
                'service_id' => $appointmentData['service']->id,
                'start_time' => $appointmentData['start_time'],
                'end_time' => $appointmentData['end_time'],
                'price_at_booking' => $appointmentData['service']->base_price,
                'currency' => 'EUR',
                'status' => $appointmentData['status'],
            ]);
        }
    }
}