<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Provider;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Admin User Demo
        $admin = User::create([
            'uuid' => (string) Str::uuid(),
            'name' => 'Admin Demo',
            'email' => 'admin@demo.local',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        // Provider User Demo
        $provider = User::create([
            'uuid' => (string) Str::uuid(),
            'name' => 'Provider Demo',
            'email' => 'provider@demo.local',
            'password' => Hash::make('password'),
            'role' => 'provider',
            'is_active' => true,
        ]);

        // Create Provider Profile
        Provider::create([
            'uuid' => (string) Str::uuid(),
            'user_id' => $provider->id,
            'business_name' => 'Demo Service Provider',
            'phone' => '+33 1 23 45 67 89',
            'address' => '123 Rue de la Démo',
            'city' => 'Paris',
            'country' => 'France',
            'description' => 'Un prestataire de démonstration pour tester l\'application',
            'legal_name' => 'SARL Demo Services',
            'tax_id' => 'FR12345678901',
        ]);
    }
}
