<?php

namespace Database\Seeders;

use App\Models\ExpenseType;
use App\Models\Provider;
use Illuminate\Database\Seeder;

class ExpenseTypeSeeder extends Seeder
{
    public function run(): void
    {
        $defaultTypes = [
            ['name' => 'Transport', 'description' => 'Frais de déplacement et transport', 'color' => '#3B82F6'],
            ['name' => 'Matériel', 'description' => 'Achat de matériel professionnel', 'color' => '#10B981'],
            ['name' => 'Marketing', 'description' => 'Publicité et communication', 'color' => '#F59E0B'],
            ['name' => 'Formation', 'description' => 'Formations et certifications', 'color' => '#8B5CF6'],
            ['name' => 'Loyer', 'description' => 'Loyer du local professionnel', 'color' => '#EF4444'],
            ['name' => 'Électricité', 'description' => 'Factures d\'électricité', 'color' => '#F97316'],
        ];

        // Créer les types par défaut pour chaque provider existant
        Provider::all()->each(function ($provider) use ($defaultTypes) {
            foreach ($defaultTypes as $type) {
                ExpenseType::create([
                    'provider_id' => $provider->id,
                    'name' => $type['name'],
                    'description' => $type['description'],
                    'color' => $type['color'],
                    'is_default' => true,
                    'is_active' => true,
                ]);
            }
        });
    }
}