# 🔐 Système de Contrôle d'Accès

## Vue d'ensemble

L'application utilise un système de rôles avec deux types d'utilisateurs :
- **Admin** : Gère les prestataires (CRUD complet)
- **Provider** : Gère son activité (clients, services, rendez-vous, finances)

## Rôles disponibles

### 1. Admin
- Accès au dashboard admin
- Gestion complète des prestataires
- Ne peut pas accéder aux routes provider

### 2. Provider
- Accès au dashboard provider
- Gestion de son profil
- Gestion de ses clients, services, rendez-vous
- Gestion de ses finances (encaissements, dépenses)
- Ne peut pas accéder aux routes admin

## Middlewares

### `admin`
```php
Route::middleware(['auth', 'active', 'admin'])
```
Vérifie que l'utilisateur est authentifié, actif et a le rôle admin.

### `provider`
```php
Route::middleware(['auth', 'active', 'provider'])
```
Vérifie que l'utilisateur est authentifié, actif et a le rôle provider.

### `active`
```php
Route::middleware(['auth', 'active'])
```
Vérifie que le compte utilisateur est actif (is_active = true).
Si désactivé, l'utilisateur est déconnecté automatiquement.

## Méthodes Helper (User Model)

```php
// Vérifier si admin
if (auth()->user()->isAdmin()) {
    // Code admin
}

// Vérifier si provider
if (auth()->user()->isProvider()) {
    // Code provider
}
```

## Redirection automatique

Depuis `/dashboard`, l'utilisateur est redirigé automatiquement :
- Admin → `/admin/dashboard`
- Provider → `/provider/dashboard`

## Sécurité

- Toutes les routes sont protégées par authentification
- Les middlewares vérifient le rôle avant chaque requête
- Accès non autorisé = HTTP 403
- Compte désactivé = déconnexion + redirection login

## Structure des routes

```
/admin/*          → Réservé aux admins
/provider/*       → Réservé aux providers
/profile          → Accessible aux deux rôles
```

## Gestion des comptes

- **Création** : Seul l'admin peut créer des providers
- **Activation/Désactivation** : Seul l'admin peut activer/désactiver un compte
- **Suppression** : Seul l'admin peut supprimer un provider
