# 🎨 Exemples d'utilisation dans Blade

## Vérifier le rôle dans les vues

### Méthode 1 : Directive @if
```blade
@if(auth()->user()->isAdmin())
    <a href="{{ route('admin.dashboard') }}">Dashboard Admin</a>
@endif

@if(auth()->user()->isProvider())
    <a href="{{ route('provider.dashboard') }}">Dashboard Provider</a>
@endif
```

### Méthode 2 : Vérification directe
```blade
@if(auth()->user()->role === 'admin')
    <!-- Contenu admin -->
@endif

@if(auth()->user()->role === 'provider')
    <!-- Contenu provider -->
@endif
```

## Menu de navigation conditionnel

```blade
<nav>
    @auth
        @if(auth()->user()->isAdmin())
            <a href="{{ route('admin.dashboard') }}">Dashboard</a>
            <a href="{{ route('admin.providers.index') }}">Prestataires</a>
        @elseif(auth()->user()->isProvider())
            <a href="{{ route('provider.dashboard') }}">Dashboard</a>
            <a href="{{ route('provider.clients.index') }}">Clients</a>
            <a href="{{ route('provider.services.index') }}">Services</a>
            <a href="{{ route('provider.appointments.index') }}">Rendez-vous</a>
            <a href="{{ route('provider.finances.index') }}">Finances</a>
        @endif
        
        <a href="{{ route('profile.edit') }}">Profil</a>
    @endauth
</nav>
```

## Affichage conditionnel de boutons

```blade
@if(auth()->user()->isAdmin())
    <button>Créer un prestataire</button>
    <button>Désactiver le compte</button>
@endif

@if(auth()->user()->isProvider())
    <button>Ajouter un client</button>
    <button>Créer un rendez-vous</button>
@endif
```

## Vérifier le statut actif

```blade
@if(auth()->user()->is_active)
    <span class="text-green-600">Compte actif</span>
@else
    <span class="text-red-600">Compte désactivé</span>
@endif
```
