PROMPT ASSISTANT – RELOOKAGE STEPPER RENDEZ-VOUS (4 ÉTAPES, MOBILE + TAILADMIN)

Contexte :
- Il existe déjà un stepper de création/édition de rendez-vous (appointments) avec toute la logique métier en place (validations, calculs, règles).
- Tu NE DOIS PAS toucher à la logique métier, ni aux règles de validation, ni à la structure des données.
- Le travail demandé concerne UNIQUEMENT le style, la disposition (layout) et l’expérience utilisateur (UX) du stepper.
- Le projet utilise Tailwind CSS et une template TailAdmin dans le dossier `tailadmin-laravel-main` :
  → tu dois t’inspirer des layouts et composants TailAdmin (cards, boutons, typographie, espacements, etc.) pour le relooking.

Objectif :
Refondre l’interface du stepper de rendez-vous en **4 étapes équilibrées**, mobile-first, avec un style cohérent TailAdmin et une ergonomie propre (boutons toujours au même endroit, contenu lisible sur petites résolutions).

Les 4 étapes existent déjà côté métier, tu dois juste les présenter ainsi au niveau UI :

1) Étape 1 – Service
2) Étape 2 – Horaire
3) Étape 3 – Prix
4) Étape 4 – Client & confirmation

Rappels importants :
- Ne PAS réécrire les règles métier.
- Ne PAS modifier les contrôleurs/services sauf si nécessaire pour brancher le nouveau stepper (mais sans changer leur logique).
- Toujours suivre le style TailAdmin (typo, couleurs, composants).

Ce que je veux que tu fasses :

1) Layout global du stepper (mobile-first)
- Créer/adapter un composant de stepper avec :
  - Une en-tête :
    - Titre de l’étape (ex. “Service”, “Date & horaire”, “Prix”, “Client & confirmation”).
    - Indicateur de progression (4 étapes) : par exemple des pastilles ou une barre de progression, inspiré de TailAdmin.
  - Une zone de contenu (une seule colonne) :
    - Card TailAdmin (fond blanc, bord arrondi, ombre légère) pour le contenu de chaque étape.
    - Pas de champs côte à côte sur mobile : tout est empilé verticalement.
  - Une barre d’actions **fixe en bas** de l’écran :
    - Toujours la même structure : bouton secondaire (Précédent / Annuler) à gauche, bouton principal (Suivant / Enregistrer) à droite.
    - Même style TailAdmin pour les boutons sur toutes les étapes.
    - Cette barre doit être toujours visible sur mobile (fixed bottom-0 w-full), quel que soit le contenu de l’étape.

2) Présentation UI des 4 étapes (sans changer les champs existants)

Étape 1 – Service :
- Afficher uniquement le choix du service sous forme de cartes ou boutons dans le style TailAdmin :
  - Chaque carte = nom du service, durée, prix.
- Disposition en une seule colonne (ou 2 colonnes sur desktop), bien espacée.
- Objectif : étape visuellement légère et très rapide.

Étape 2 – Horaire
- IMPORTANT : l’horaire existe déjà sous forme d’une barre avec les heures de la journée et deux “pointeurs” (slider) pour choisir l’heure de début et l’heure de fin.
- Tu NE DOIS PAS remplacer cette logique par des champs texte ou des selects : tu dois simplement la rendre plus élégante et lisible dans le style TailAdmin.

UI attendue :
- Card TailAdmin contenant :
  - Un petit titre clair, par exemple “Choisissez la durée de la séance”.
  - La barre horaire existante (slider) :
    - bien intégrée visuellement (bonne hauteur, couleurs TailAdmin, poignée de slider visibles et facilement manipulables au doigt sur mobile),
    - labels d’heures lisibles (ex. 08h, 09h, 10h…).
  - Sous la barre, afficher en texte la plage choisie, par exemple :
    - “Début : 10:00 – Fin : 11:30”
    - dans un style lisible (typo TailAdmin, contraste suffisant).

Contraintes :
- Pas de champ “Date” dans cette étape : la date vient déjà du calendrier (clic sur jour) et est gérée dans les étapes ou le contexte existant.
- Ne PAS changer la logique métier du slider (calcul de start_time et end_time, validations, etc.), seulement le style et la disposition.
- Sur mobile, la barre + le texte doivent tenir en une seule colonne, sans scroll horizontal.

Les boutons “Précédent / Suivant” restent, comme pour les autres étapes, dans la barre fixe en bas de l’écran, au même emplacement et avec le même style TailAdmin.

Étape 3 – Prix :
- Card avec :
  - Champ prix (input stylé TailAdmin).
  - Éventuels champs liés au prix déjà existants (ne pas en inventer).
- Le champ prix doit être bien mis en valeur (titre clair, taille suffisante).
- Il n’y a pas besoin de coder de nouvelle logique de calcul, tu dois juste afficher/éditer le champ comme aujourd’hui mais avec un rendu pro.

Étape 4 – Client & confirmation :
- En haut de la card, un récapitulatif compact :
  - Service, Date, Heure début/fin, Prix.
- En dessous :
  - Partie “Client” :
    - champ de recherche client + liste stylée (TailAdmin),
    - bouton “+ Nouveau client” bien visible.
  - Partie “Détails finaux” (avec les champs déjà existants) :
    - Notes,
    - Statut, etc.
- En bas, dans la barre d’actions fixe, le bouton principal = “Enregistrer la séance”.

3) Style TailAdmin & responsive
- Reprendre les classes Tailwind/TailAdmin pour :
  - Cards,
  - Buttons (primary/secondary),
  - Inputs,
  - Typographie (titres, sous-titres),
  - Espacements (paddings, margins).
- S’assurer que :
  - Sur mobile, le stepper prend l’écran complet (ou une grande modale), avec scroll vertical uniquement pour le contenu.
  - Les boutons “Précédent / Suivant / Enregistrer” restent toujours au même endroit visuel, sans remonter/descendre d’une étape à l’autre.

4) Implémentation
- Utiliser Blade + JS/Alpine ou Livewire (selon ce qui est déjà utilisé pour le stepper actuel) pour :
  - gérer la navigation entre les 4 étapes,
  - réutiliser les mêmes données/états que l’ancien stepper (pas de nouvelle structure métier).
- Me fournir :
  - Les nouvelles vues Blade / composants créés pour le stepper,
  - Les fichiers modifiés (vues, composants, éventuellement layout),
  - Un bref commentaire sur la structure (où se trouve la logique d’affichage du stepper).

Encore une fois : tout ce travail est uniquement cosmétique et UX. La logique métier (validations, calculs, règles d’interdiction de chevauchement, etc.) ne doit pas être modifiée.

Fin.
