@extends('admin.layout')

@section('title', 'Providers')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-4 sm:p-6">
        <!-- Header mobile-first -->
        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-6 space-y-4 sm:space-y-0">
            <h2 class="text-xl sm:text-2xl font-bold text-gray-900">Prestataires</h2>
            <a href="{{ route('admin.providers.create') }}" 
               class="inline-flex items-center justify-center w-full sm:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors duration-200 shadow-sm">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Ajouter un prestataire
            </a>
        </div>

        <!-- Mobile cards -->
        <div class="block sm:hidden space-y-4">
            @foreach($providers as $provider)
            <div class="bg-gray-50 rounded-lg p-4 border">
                <div class="flex justify-between items-start mb-3">
                    <div>
                        <h3 class="font-semibold text-gray-900">{{ $provider->business_name }}</h3>
                        <p class="text-sm text-gray-600">{{ $provider->user->name }}</p>
                    </div>
                    <div class="flex space-x-2">
                        <a href="{{ route('admin.providers.edit', $provider->uuid) }}" 
                           class="bg-blue-100 text-blue-700 px-3 py-1 rounded text-sm font-medium hover:bg-blue-200">
                            Modifier
                        </a>
                        <form action="{{ route('admin.providers.destroy', $provider->uuid) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="bg-red-100 text-red-700 px-3 py-1 rounded text-sm font-medium hover:bg-red-200" 
                                    onclick="return confirm('Êtes-vous sûr ?')">
                                Supprimer
                            </button>
                        </form>
                    </div>
                </div>
                <div class="text-sm text-gray-600 space-y-1">
                    <p><span class="font-medium">Email:</span> {{ $provider->user->email }}</p>
                    <p><span class="font-medium">Téléphone:</span> {{ $provider->phone }}</p>
                    <p><span class="font-medium">Statut:</span> 
                        <span class="{{ $provider->user->is_active ? 'text-green-600' : 'text-red-600' }} font-medium">
                            {{ $provider->user->is_active ? 'Actif' : 'Inactif' }}
                        </span>
                    </p>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Desktop table -->
        <div class="hidden sm:block overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nom commercial</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nom</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Téléphone</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Statut</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($providers as $provider)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $provider->business_name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $provider->user->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $provider->user->email }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $provider->phone }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full {{ $provider->user->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $provider->user->is_active ? 'Actif' : 'Inactif' }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                            <a href="{{ route('admin.providers.edit', $provider->uuid) }}" 
                               class="text-blue-600 hover:text-blue-900 font-medium">Modifier</a>
                            <form action="{{ route('admin.providers.destroy', $provider->uuid) }}" method="POST" class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="text-red-600 hover:text-red-900 font-medium" 
                                        onclick="return confirm('Êtes-vous sûr ?')">
                                    Supprimer
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-6">
            {{ $providers->links() }}
        </div>
    </div>
</div>
@endsection
