@extends('layouts.mobile')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="max-w-md mx-auto px-4 py-4">
            <h1 class="text-xl font-semibold text-center">Calendar</h1>
        </div>
    </div>

    <!-- Calendar Widget -->
    <div class="max-w-md mx-auto p-4">
        <div class="bg-white rounded-2xl shadow-sm p-4 mb-4">
            <!-- Month Navigation -->
            <div class="flex items-center justify-between mb-4">
                <button onclick="changeMonth(-1)" class="p-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                <h2 class="text-lg font-semibold" id="monthYear">{{ $selectedDate->format('F Y') }}</h2>
                <button onclick="changeMonth(1)" class="p-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
            </div>

            <!-- Calendar Grid -->
            <div class="grid grid-cols-7 gap-1 text-center text-sm">
                <div class="py-2 text-gray-500 font-medium">M</div>
                <div class="py-2 text-gray-500 font-medium">Tu</div>
                <div class="py-2 text-gray-500 font-medium">W</div>
                <div class="py-2 text-gray-500 font-medium">Th</div>
                <div class="py-2 text-gray-500 font-medium">F</div>
                <div class="py-2 text-gray-500 font-medium">Sa</div>
                <div class="py-2 text-gray-500 font-medium">Su</div>
                
                <div id="calendarDays" class="col-span-7 grid grid-cols-7 gap-1">
                    <!-- Days will be generated by JavaScript -->
                </div>
            </div>
        </div>

        <!-- Selected Date -->
        <div class="mb-4">
            <h3 class="text-gray-600 font-medium" id="selectedDateText">{{ $selectedDate->format('l, F j, Y') }}</h3>
        </div>

        <!-- Appointments List -->
        <div class="space-y-3" id="appointmentsList">
            @forelse($appointments as $appointment)
                <div class="bg-white rounded-xl p-4 shadow-sm">
                    <div class="flex items-start justify-between">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-2">
                                <div class="text-sm text-gray-600">
                                    {{ $appointment->start_time->format('g a') }}<br>
                                    <span class="text-xs">{{ number_format($appointment->getDurationInHours(), 1) }} hr</span>
                                </div>
                                <div class="flex-1">
                                    <div class="text-xs font-medium px-2 py-1 rounded {{ $appointment->getStatusColorClass() }} mb-1">
                                        {{ $appointment->getStatusLabel() }}
                                    </div>
                                    <h4 class="font-semibold text-gray-900">{{ $appointment->service->name }}</h4>
                                    @if($appointment->client->address)
                                        <p class="text-sm text-gray-600">@ {{ $appointment->client->address }}</p>
                                    @endif
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                    <span class="text-xs font-semibold text-blue-600">{{ $appointment->getClientInitials() }}</span>
                                </div>
                                <span class="text-sm text-gray-700">{{ $appointment->client->first_name }} {{ $appointment->client->last_name }}</span>
                            </div>
                        </div>
                        <button class="p-2 text-gray-400">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            @empty
                <div class="text-center py-8 text-gray-500">
                    <p>Aucun rendez-vous pour cette date</p>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Bottom Navigation -->
    <div class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200">
        <div class="max-w-md mx-auto px-4 py-2">
            <div class="flex justify-around">
                <a href="{{ route('appointments.create') }}" class="flex flex-col items-center py-2 text-gray-400">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    <span class="text-xs">Create</span>
                </a>
                <a href="{{ route('calendar.index') }}" class="flex flex-col items-center py-2 text-blue-600">
                    <svg class="w-6 h-6 mb-1" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"/>
                    </svg>
                    <span class="text-xs font-medium">Calendar</span>
                </a>
                <a href="#" class="flex flex-col items-center py-2 text-gray-400">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    <span class="text-xs">Messages</span>
                </a>
                <a href="{{ route('profile.edit') }}" class="flex flex-col items-center py-2 text-gray-400">
                    <svg class="w-6 h-6 mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    <span class="text-xs">Account</span>
                </a>
            </div>
        </div>
    </div>
</div>

<script>
let currentDate = new Date('{{ $selectedDate->format('Y-m-d') }}');

function generateCalendar() {
    const year = currentDate.getFullYear();
    const month = currentDate.getMonth();
    
    // Update month/year display
    document.getElementById('monthYear').textContent = 
        new Date(year, month).toLocaleDateString('en-US', { month: 'long', year: 'numeric' });
    
    // Get first day of month and number of days
    const firstDay = new Date(year, month, 1);
    const lastDay = new Date(year, month + 1, 0);
    const daysInMonth = lastDay.getDate();
    const startingDayOfWeek = (firstDay.getDay() + 6) % 7; // Monday = 0
    
    const calendarDays = document.getElementById('calendarDays');
    calendarDays.innerHTML = '';
    
    // Add empty cells for days before month starts
    for (let i = 0; i < startingDayOfWeek; i++) {
        const emptyDay = document.createElement('div');
        emptyDay.className = 'py-2';
        calendarDays.appendChild(emptyDay);
    }
    
    // Add days of the month
    for (let day = 1; day <= daysInMonth; day++) {
        const dayElement = document.createElement('div');
        dayElement.className = 'py-2 cursor-pointer hover:bg-gray-100 rounded';
        dayElement.textContent = day;
        
        // Highlight selected date
        const dayDate = new Date(year, month, day);
        if (dayDate.toDateString() === new Date('{{ $selectedDate->format('Y-m-d') }}').toDateString()) {
            dayElement.className += ' bg-blue-600 text-white font-semibold';
        }
        
        dayElement.onclick = () => selectDate(year, month, day);
        calendarDays.appendChild(dayElement);
    }
}

function changeMonth(direction) {
    currentDate.setMonth(currentDate.getMonth() + direction);
    generateCalendar();
}

function selectDate(year, month, day) {
    const selectedDate = new Date(year, month, day);
    const dateString = selectedDate.toISOString().split('T')[0];
    window.location.href = `{{ route('calendar.index') }}?date=${dateString}`;
}

// Initialize calendar
generateCalendar();
</script>
@endsection