@props(['appointment'])

<div class="bg-white rounded-xl p-4 shadow-sm">
    <div class="flex items-start justify-between">
        <div class="flex-1">
            <div class="flex items-center gap-3 mb-2">
                <div class="text-sm text-gray-600">
                    {{ $appointment->start_time->format('g a') }}<br>
                    <span class="text-xs">{{ number_format($appointment->getDurationInHours(), 1) }} hr</span>
                </div>
                <div class="flex-1">
                    <div class="text-xs font-medium px-2 py-1 rounded {{ $appointment->getStatusColorClass() }} mb-1">
                        {{ $appointment->getStatusLabel() }}
                    </div>
                    <h4 class="font-semibold text-gray-900">{{ $appointment->service->name }}</h4>
                    @if($appointment->client->address)
                        <p class="text-sm text-gray-600">@ {{ $appointment->client->address }}</p>
                    @endif
                </div>
            </div>
            <div class="flex items-center gap-2">
                <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                    <span class="text-xs font-semibold text-blue-600">{{ $appointment->getClientInitials() }}</span>
                </div>
                <span class="text-sm text-gray-700">{{ $appointment->client->first_name }} {{ $appointment->client->last_name }}</span>
            </div>
        </div>
        <button class="p-2 text-gray-400 hover:text-gray-600">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
            </svg>
        </button>
    </div>
</div>