@props(['client' => null, 'action', 'method' => 'POST', 'submitText' => 'Créer le client', 'cancelUrl', 'redirectTo' => 'index'])

@php
$isEdit = $client !== null;
@endphp

<form action="{{ $action }}" method="POST" class="space-y-6 pb-24">
    @csrf
    @if($method !== 'POST')
        @method($method)
    @endif
    <input type="hidden" name="redirect_to" value="{{ $redirectTo }}">
    
    <!-- Informations personnelles -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Informations personnelles</h3>
        </x-slot>
        
        <div class="space-y-4">
            <div class="grid grid-cols-2 gap-4">
                <x-input 
                    name="first_name" 
                    label="Prénom" 
                    value="{{ old('first_name', $client?->first_name) }}" 
                    required
                    error="{{ $errors->first('first_name') }}"
                />

                <x-input 
                    name="last_name" 
                    label="Nom de famille" 
                    value="{{ old('last_name', $client?->last_name) }}"
                    error="{{ $errors->first('last_name') }}"
                />
            </div>

            <div class="grid grid-cols-2 gap-4">
                <x-select 
                    name="gender" 
                    label="Genre"
                    error="{{ $errors->first('gender') }}"
                >
                    <option value="unknown" {{ old('gender', $client?->gender) == 'unknown' ? 'selected' : '' }}>Non spécifié</option>
                    <option value="male" {{ old('gender', $client?->gender) == 'male' ? 'selected' : '' }}>Homme</option>
                    <option value="female" {{ old('gender', $client?->gender) == 'female' ? 'selected' : '' }}>Femme</option>
                    <option value="other" {{ old('gender', $client?->gender) == 'other' ? 'selected' : '' }}>Autre</option>
                </x-select>

                <x-input 
                    type="date" 
                    name="birth_date" 
                    label="Date de naissance" 
                    value="{{ old('birth_date', $client?->birth_date?->format('Y-m-d')) }}"
                    error="{{ $errors->first('birth_date') }}"
                />
            </div>
        </div>
    </x-card>

    <!-- Informations de contact -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Informations de contact</h3>
        </x-slot>
        
        <div class="grid grid-cols-2 gap-4">
            <x-input 
                type="tel" 
                name="phone" 
                label="Téléphone" 
                value="{{ old('phone', $client?->phone) }}" 
                placeholder="06 12 34 56 78"
                error="{{ $errors->first('phone') }}"
            />

            <x-input 
                type="email" 
                name="email" 
                label="Email" 
                value="{{ old('email', $client?->email) }}" 
                placeholder="client@example.com"
                error="{{ $errors->first('email') }}"
            />
        </div>
    </x-card>

    <!-- Notes -->
    <x-card>
        <x-textarea 
            name="notes" 
            label="Notes" 
            rows="4" 
            placeholder="Notes sur le client, préférences, historique médical, etc."
            error="{{ $errors->first('notes') }}"
        >{{ old('notes', $client?->notes) }}</x-textarea>
    </x-card>
    
    <!-- Bouton fixe au-dessus de la navigation du bas -->
    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <div class="flex gap-3">
            <x-button href="{{ $cancelUrl }}" variant="secondary" class="flex-1">
                Annuler
            </x-button>
            <x-button type="submit" class="flex-1">
                {{ $submitText }}
            </x-button>
        </div>
    </div>
</form>