@props([
    'expenseType' => null
])

@php
    $isEdit = !is_null($expenseType);
    $action = $isEdit 
        ? route('provider.expense-types.update', $expenseType->uuid)
        : route('provider.expense-types.store');
    $method = $isEdit ? 'PUT' : 'POST';
    $title = $isEdit ? 'Modifier le type de dépense' : 'Nouveau type de dépense';
    $submitText = $isEdit ? 'Modifier le type' : 'Créer le type';
@endphp

<x-card>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ $title }}</h3>
            <x-button href="{{ route('provider.finances.index', ['tab' => 'types-depense']) }}" variant="secondary" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Retour
            </x-button>
        </div>
    </x-slot>

    <form action="{{ $action }}" method="POST" class="space-y-6 pb-24">
        @csrf
        @if($isEdit)
            @method('PUT')
        @endif
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="md:col-span-2">
                <x-input 
                    type="text" 
                    name="name" 
                    label="Nom du type" 
                    value="{{ old('name', $isEdit ? $expenseType->name : '') }}"
                    required
                    placeholder="Ex: Transport, Matériel, Marketing..."
                    error="{{ $errors->first('name') }}"
                />
            </div>

            <div class="md:col-span-2">
                <x-textarea 
                    name="description" 
                    label="Description" 
                    rows="3"
                    placeholder="Description optionnelle du type de dépense..."
                    value="{{ old('description', $isEdit ? $expenseType->description : '') }}"
                />
            </div>

            <div class="flex items-center md:col-span-2">
                <div class="flex items-center h-5">
                    <input type="checkbox" 
                           id="is_active" 
                           name="is_active" 
                           value="1"
                           {{ old('is_active', $isEdit ? $expenseType->is_active : true) ? 'checked' : '' }}
                           class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded">
                </div>
                <div class="ml-3">
                    <label for="is_active" class="text-sm font-medium text-gray-700 dark:text-gray-300">
                        Type actif
                    </label>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Ce type sera disponible lors de la création de dépenses</p>
                </div>
            </div>
        </div>

        @if($isEdit && $expenseType->is_default)
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <div class="flex">
                    <svg class="w-5 h-5 text-blue-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <p class="text-sm text-blue-700 dark:text-blue-300">
                        Ce type de dépense est marqué comme "par défaut" et ne peut pas être supprimé.
                    </p>
                </div>
            </div>
        @endif

        <!-- Bouton fixe au-dessus de la navigation du bas -->
        <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
            <div class="flex gap-3">
                <x-button href="{{ route('provider.finances.index', ['tab' => 'types-depense']) }}" variant="secondary" class="flex-1">
                    Annuler
                </x-button>
                <x-button type="submit" class="flex-1">
                    {{ $submitText }}
                </x-button>
            </div>
        </div>
    </form>
</x-card>

