@props(['active' => ''])

<nav class="flex overflow-x-auto rounded-lg bg-gray-100 p-1 dark:bg-gray-900 [&::-webkit-scrollbar]:h-1.5 [&::-webkit-scrollbar-track]:bg-white dark:[&::-webkit-scrollbar-track]:bg-transparent [&::-webkit-scrollbar-thumb]:rounded-full [&::-webkit-scrollbar-thumb]:bg-gray-200 dark:[&::-webkit-scrollbar-thumb]:bg-gray-600">
    <a href="{{ route('provider.finances.index') }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'synthese' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Synthèse
    </a>
    <a href="{{ route('provider.finances.index', ['tab' => 'factures']) }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'factures' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Factures
    </a>
    <a href="{{ route('provider.finances.index', ['tab' => 'depenses']) }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'depenses' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Dépenses
    </a>
    <a href="{{ route('provider.finances.index', ['tab' => 'types-depense']) }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'types-depense' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Types de dépenses
    </a>
    <a href="{{ route('provider.suppliers.index') }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'fournisseurs' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Fournisseurs
    </a>
</nav>