@props(['label' => null, 'error' => null, 'required' => false, 'options' => [], 'value' => null])

<div class="space-y-1">
    @if($label)
        <label {{ $attributes->only('for') }} class="block text-sm font-medium text-gray-700 dark:text-gray-300">
            {{ $label }}
            @if($required)
                <span class="text-red-500">*</span>
            @endif
        </label>
    @endif
    
    <select {{ $attributes->except(['label', 'error', 'required', 'options', 'value'])->merge(['class' => 'block w-full rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring-primary sm:text-sm dark:bg-gray-700 dark:border-gray-600 dark:text-white' . ($error ? ' border-red-300 focus:border-red-500 focus:ring-red-500' : '')]) }}>
        @if(isset($slot) && !$slot->isEmpty())
            {{ $slot }}
        @else
            @foreach($options as $value => $text)
                <option value="{{ $value }}">{{ $text }}</option>
            @endforeach
        @endif
    </select>
    
    @if($error)
        <p class="text-sm text-red-600 dark:text-red-400">{{ $error }}</p>
    @endif
</div>