@props(['active' => 'fiscal'])

<nav class="flex overflow-x-auto rounded-lg bg-gray-100 p-1 dark:bg-gray-900 [&::-webkit-scrollbar]:h-1.5 [&::-webkit-scrollbar-track]:bg-white dark:[&::-webkit-scrollbar-track]:bg-transparent [&::-webkit-scrollbar-thumb]:rounded-full [&::-webkit-scrollbar-thumb]:bg-gray-200 dark:[&::-webkit-scrollbar-thumb]:bg-gray-600">
    <a href="{{ route('provider.settings.fiscal.edit') }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'fiscal' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Informations fiscales
    </a>
    <a href="{{ route('provider.services.index') }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'services' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Services & Tarifs
    </a>
    <a href="{{ route('provider.settings.general.edit') }}" 
       class="inline-flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors duration-200 ease-in-out whitespace-nowrap {{ $active === 'general' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/[0.03] dark:text-white' : 'bg-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}">
        Paramètres généraux
    </a>
</nav>