@props(['supplier' => null])

<form action="{{ $supplier ? route('provider.suppliers.update', $supplier->uuid) : route('provider.suppliers.store') }}" method="POST" class="space-y-6 pb-24">
    @csrf
    @if($supplier)
        @method('PUT')
    @endif
    
    <div class="grid grid-cols-2 gap-4">
        <div class="col-span-2">
            <x-input name="name" label="Nom" value="{{ old('name', $supplier->name ?? '') }}" required error="{{ $errors->first('name') }}" />
        </div>
        <x-input type="email" name="email" label="Email" value="{{ old('email', $supplier->email ?? '') }}" error="{{ $errors->first('email') }}" />
        <x-input type="tel" name="phone" label="Téléphone" value="{{ old('phone', $supplier->phone ?? '') }}" error="{{ $errors->first('phone') }}" />
        <div class="col-span-2">
            <x-input name="tax_id" label="Matricule fiscal" value="{{ old('tax_id', $supplier->tax_id ?? '') }}" error="{{ $errors->first('tax_id') }}" />
        </div>
        <div class="col-span-2">
            <x-textarea name="address" label="Adresse" rows="3" error="{{ $errors->first('address') }}">{{ old('address', $supplier->address ?? '') }}</x-textarea>
        </div>
        <div class="col-span-2">
            <x-textarea name="notes" label="Notes" rows="3" error="{{ $errors->first('notes') }}">{{ old('notes', $supplier->notes ?? '') }}</x-textarea>
        </div>
        <div class="col-span-2 flex items-center">
            <div class="flex items-center h-5">
                <input type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $supplier->is_active ?? true) ? 'checked' : '' }} class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded">
            </div>
            <div class="ml-3">
                <label for="is_active" class="text-sm font-medium text-gray-700 dark:text-gray-300">Fournisseur actif</label>
                <p class="text-sm text-gray-500 dark:text-gray-400">Ce fournisseur sera disponible lors de la création de dépenses</p>
            </div>
        </div>
    </div>

    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <div class="flex gap-3">
            <x-button href="{{ route('provider.suppliers.index') }}" variant="secondary" class="flex-1">Annuler</x-button>
            <x-button type="submit" class="flex-1">Enregistrer</x-button>
        </div>
    </div>
</form>
