@extends('layouts.provider')

@section('title', 'Liste des Rendez-vous')
@section('page-title', 'Liste des Rendez-vous')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <x-card>
        <div class="flex items-center justify-between">
            <div class="flex space-x-4">
                <a href="{{ route('provider.appointments.calendar') }}" 
                   class="text-sm text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                    Calendrier
                </a>
                <a href="{{ route('provider.appointments.index') }}" 
                   class="text-sm text-primary font-medium">
                    Liste
                </a>
            </div>
            <x-button href="{{ route('provider.appointments.create') }}" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouveau
            </x-button>
        </div>
    </x-card>

    <!-- Filtres -->
    <x-card>
        <form method="GET" action="{{ route('provider.appointments.index') }}" class="space-y-4">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div>
                    <x-input name="search" value="{{ request('search') }}" placeholder="Rechercher..." />
                </div>
                <div>
                    <select name="status" class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-primary focus:border-primary">
                        <option value="">Tous les statuts</option>
                        <option value="scheduled" {{ request('status') === 'scheduled' ? 'selected' : '' }}>Programmé</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Terminé</option>
                        <option value="canceled" {{ request('status') === 'canceled' ? 'selected' : '' }}>Annulé</option>
                        <option value="no_show" {{ request('status') === 'no_show' ? 'selected' : '' }}>Absent</option>
                    </select>
                </div>
                <div>
                    <select name="client_id" class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-primary focus:border-primary">
                        <option value="">Tous les clients</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->full_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <select name="service_id" class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-primary focus:border-primary">
                        <option value="">Tous les services</option>
                        @foreach($services as $service)
                            <option value="{{ $service->id }}" {{ request('service_id') == $service->id ? 'selected' : '' }}>
                                {{ $service->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                <div>
                    <input type="date" name="date_from" value="{{ request('date_from') }}" 
                           class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-primary focus:border-primary">
                </div>
                <div>
                    <input type="date" name="date_to" value="{{ request('date_to') }}" 
                           class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-primary focus:border-primary">
                </div>
                <div class="flex gap-2">
                    <x-button type="submit" variant="secondary" size="sm" class="flex-1">
                        Filtrer
                    </x-button>
                    @if(request()->hasAny(['search', 'status', 'client_id', 'service_id', 'date_from', 'date_to']))
                        <x-button href="{{ route('provider.appointments.index') }}" variant="secondary" size="sm">
                            Effacer
                        </x-button>
                    @endif
                </div>
            </div>
        </form>
    </x-card>

    @if($appointments->count() > 0)
        <!-- Mobile cards -->
        <div class="block sm:hidden space-y-3">
            @foreach($appointments as $appointment)
                <x-card class="border-l-4" style="border-left-color: {{ $appointment->service->color ?? '#3B82F6' }}">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center mb-2">
                                <h3 class="font-semibold text-gray-900 dark:text-white">
                                    {{ $appointment->start_time->format('d/m/Y H:i') }}
                                </h3>
                                <span class="ml-2 px-2 py-1 text-xs rounded-full
                                    {{ $appointment->status === 'scheduled' ? 'bg-blue-100 text-blue-800' : '' }}
                                    {{ $appointment->status === 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                    {{ $appointment->status === 'canceled' ? 'bg-red-100 text-red-800' : '' }}
                                    {{ $appointment->status === 'no_show' ? 'bg-gray-100 text-gray-800' : '' }}">
                                    {{ ucfirst($appointment->status) }}
                                </span>
                            </div>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                {{ $appointment->client ? $appointment->client->full_name : 'Sans client' }}
                            </p>
                            @if($appointment->service)
                                <p class="text-sm text-gray-600 dark:text-gray-400 mb-1">{{ $appointment->service->name }}</p>
                            @endif
                            @if($appointment->price_at_booking)
                                <p class="text-sm font-medium text-gray-900 dark:text-white">{{ number_format($appointment->price_at_booking, 2) }} {{ $appointment->currency }}</p>
                            @endif
                        </div>
                        <div class="flex space-x-2 ml-4">
                            <x-button href="{{ route('provider.appointments.edit', $appointment->uuid) }}" variant="secondary" size="sm">
                                Modifier
                            </x-button>
                        </div>
                    </div>
                </x-card>
            @endforeach
        </div>

        <!-- Desktop table -->
        <x-card class="hidden sm:block">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-800">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Date & Heure</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Client</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Service</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Statut</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Montant</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach($appointments as $appointment)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-800">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $appointment->start_time->format('d/m/Y H:i') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $appointment->client ? $appointment->client->full_name : 'Sans client' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($appointment->service)
                                    <div class="flex items-center">
                                        <div class="w-4 h-4 rounded-full mr-3" style="background-color: {{ $appointment->service->color }}"></div>
                                        <span class="text-sm text-gray-900 dark:text-white">{{ $appointment->service->name }}</span>
                                    </div>
                                @else
                                    <span class="text-sm text-gray-500 dark:text-gray-400">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 text-xs font-medium rounded-full
                                    {{ $appointment->status === 'scheduled' ? 'bg-blue-100 text-blue-800' : '' }}
                                    {{ $appointment->status === 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                    {{ $appointment->status === 'canceled' ? 'bg-red-100 text-red-800' : '' }}
                                    {{ $appointment->status === 'no_show' ? 'bg-gray-100 text-gray-800' : '' }}">
                                    {{ ucfirst($appointment->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                {{ $appointment->price_at_booking ? number_format($appointment->price_at_booking, 2) . ' ' . $appointment->currency : '-' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <x-button href="{{ route('provider.appointments.edit', $appointment->uuid) }}" variant="secondary" size="sm">
                                    Modifier
                                </x-button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </x-card>

        <!-- Pagination -->
        <div>
            {{ $appointments->appends(request()->query())->links() }}
        </div>
    @else
        <x-card class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun rendez-vous</h3>
            <p class="mt-1 text-sm text-gray-500">Commencez par créer votre premier rendez-vous.</p>
            <div class="mt-6">
                <x-button href="{{ route('provider.appointments.create') }}">
                    <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    Nouveau rendez-vous
                </x-button>
            </div>
        </x-card>
    @endif
</div>
@endsection
