@extends('layouts.provider')

@section('title', 'Nouveau Client')
@section('page-title', 'Nouveau Client')

@section('content')
<x-card>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Nouveau client</h3>
            <x-button href="{{ route('provider.clients.index') }}" variant="secondary" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Retour
            </x-button>
        </div>
    </x-slot>

    <x-client-form 
        :action="route('provider.clients.store')"
        submit-text="Créer le client"
        :cancel-url="route('provider.clients.index')"
    />
</x-card>
@endsection
