@extends('layouts.provider')

@section('title', 'Modifier le Client')
@section('page-title')
    Modifier {{ $client->full_name }}
@endsection

@section('content')
<x-card>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Modifier le client</h3>
            <x-button href="{{ route('provider.clients.index') }}" variant="secondary" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Retour
            </x-button>
        </div>
    </x-slot>

    <x-client-form 
        :client="$client"
        :action="route('provider.clients.update', $client->uuid)"
        method="PUT"
        submit-text="Enregistrer les modifications"
        :cancel-url="request()->query('from') === 'show' ? route('provider.clients.show', $client->uuid) : route('provider.clients.index')"
        :redirectTo="request()->query('from') === 'show' ? 'show' : 'index'"
    />
</x-card>
@endsection
