@extends('layouts.provider')

@section('title', 'Mes Clients')
@section('page-title', $showArchived ? 'Clients Archivés' : 'Mes Clients')

@section('content')
<x-card>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Mes Clients</h3>
                <div class="flex space-x-4">
                    <a href="{{ route('provider.clients.index') }}" 
                       class="text-sm {{ !$showArchived ? 'text-primary font-medium' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300' }}">
                        Clients actifs
                    </a>
                    <a href="{{ route('provider.clients.index', ['archived' => 1]) }}" 
                       class="text-sm {{ $showArchived ? 'text-primary font-medium' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300' }}">
                        Clients archivés
                    </a>
                </div>
            </div>
            <x-button href="{{ route('provider.clients.create') }}" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouveau
            </x-button>
        </div>
    </x-slot>

    <div class="space-y-6">
    <!-- Recherche -->
    <div>
        <form method="GET" action="{{ route('provider.clients.index') }}" class="flex flex-wrap gap-3 items-end">
            @if($showArchived)
                <input type="hidden" name="archived" value="1">
            @endif
            <div class="flex-1 min-w-[140px]">
                <x-input 
                    name="search" 
                    label="Recherche" 
                    value="{{ request('search') }}" 
                    placeholder="Nom, téléphone..."
                />
            </div>
            <div class="flex gap-2 flex-shrink-0">
                <x-button type="submit" class="h-10 px-3" title="Filtrer">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                    </svg>
                </x-button>
                <x-button href="{{ route('provider.clients.index', $showArchived ? ['archived' => 1] : []) }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </x-button>
            </div>
        </form>
    </div>

    @if($clients->count() > 0)
        <!-- Liste clients -->
        <div class="space-y-3">
            @foreach($clients as $client)
                <x-card class="hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center space-x-2">
                                <h3 class="font-semibold text-gray-900 dark:text-white">{{ $client->full_name }}</h3>
                                @if($client->phone)
                                    <span class="text-sm text-gray-600 dark:text-gray-400">{{ $client->phone }}</span>
                                @endif
                            </div>
                            <div class="text-xs text-gray-500 mt-2">
                                @if($client->appointments_count > 0)
                                    <div>
                                        Rendez-vous: 
                                        @php $parts = []; @endphp
                                        @if($client->complete_count > 0)
                                            @php $parts[] = '<span class="text-green-600">' . $client->complete_count . ' terminés</span>'; @endphp
                                        @endif
                                        @if($client->scheduled_count > 0)
                                            @php $parts[] = '<span class="text-blue-600">' . $client->scheduled_count . ' en attente</span>'; @endphp
                                        @endif
                                        @if($client->cancelled_count > 0)
                                            @php $parts[] = '<span class="text-red-600">' . $client->cancelled_count . ' annulés</span>'; @endphp
                                        @endif
                                        {!! implode(' et ', $parts) !!}
                                    </div>
                                    <div class="mt-1 flex space-x-4">
                                        @if($client->last_visit_at)
                                            <span>Dernière : {{ $client->last_visit_at->format('d/m/Y') }}</span>
                                        @endif
                                        @if($client->next_visit_at)
                                            <span class="text-primary">Prochaine : {{ $client->next_visit_at->format('d/m/Y') }}</span>
                                        @endif
                                    </div>
                                @else
                                    Aucun rendez-vous
                                @endif
                            </div>
                        </div>
                        <div class="flex space-x-2">
                            @if($showArchived)
                                <form action="{{ route('provider.clients.restore', $client->uuid) }}" method="POST" class="inline">
                                    @csrf
                                    <x-button type="submit" variant="secondary" size="sm">
                                        Restaurer
                                    </x-button>
                                </form>
                            @else
                                <x-button href="{{ route('provider.clients.show', $client->uuid) }}" variant="secondary" size="sm">
                                    Voir
                                </x-button>
                                <x-button href="{{ route('provider.clients.edit', $client->uuid) }}" variant="secondary" size="sm">
                                    Modifier
                                </x-button>
                            @endif
                        </div>
                    </div>
                </x-card>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-6">
            {{ $clients->appends(request()->query())->links() }}
        </div>
    @else
        <div class="text-center py-12">
            @if($showArchived)
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8l6 6m0 0l6-6m-6 6v9a2 2 0 01-2 2H9a2 2 0 01-2-2v-9m8 0V9a2 2 0 00-2-2H9a2 2 0 00-2 2v8.92m0 0H15m-6 0H9" />
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun client archivé</h3>
                <p class="mt-1 text-sm text-gray-500">Vous n'avez pas encore archivé de clients.</p>
            @else
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun client</h3>
                <p class="mt-1 text-sm text-gray-500">Commencez par créer votre premier client.</p>
                <div class="mt-6">
                    <x-button href="{{ route('provider.clients.create') }}">
                        <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                        </svg>
                        Nouveau client
                    </x-button>
                </div>
            @endif
        </div>
    @endif
    </div>
</x-card>
@endsection
