@extends('layouts.provider')

@section('title', $client->full_name)

@section('content')
<div class="space-y-6 pb-24">
    <!-- Header avec actions -->
    <x-card>
            <div class="flex flex-col sm:flex-row sm:justify-between sm:items-start mb-6">
                <div>
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-2">{{ $client->full_name }}</h1>
                    <div class="flex flex-wrap gap-4 text-sm text-gray-600 dark:text-gray-400">
                        @if($client->birth_date)
                            <span>{{ $client->birth_date->age }} ans</span>
                        @endif
                        @if($client->gender !== 'unknown')
                            <span>{{ ucfirst($client->gender === 'male' ? 'Homme' : ($client->gender === 'female' ? 'Femme' : 'Autre')) }}</span>
                        @endif
                        @if($client->last_visit_at)
                            <span>Dernière visite : {{ $client->last_visit_at->format('d/m/Y') }}</span>
                        @endif
                    </div>
                </div>
                <div class="flex flex-row gap-2 mt-4 sm:mt-0">
                    <x-button href="{{ route('provider.clients.index') }}" variant="secondary" size="sm" class="w-10 h-10 p-0">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.clients.edit', $client->uuid) }}?from=show" class="flex-1">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                        Modifier
                    </x-button>
                    <form action="{{ route('provider.clients.destroy', $client->uuid) }}" method="POST" class="inline">
                        @csrf
                        @method('DELETE')
                        <x-button type="submit" variant="secondary" size="sm" class="w-10 h-10 p-0" title="Archiver">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                            </svg>
                        </x-button>
                    </form>
                </div>
            </div>

            <!-- Informations de contact -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                @if($client->phone)
                <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                    </svg>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Téléphone</p>
                        <p class="font-medium dark:text-white">{{ $client->phone }}</p>
                    </div>
                </div>
                @endif

                @if($client->email)
                <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Email</p>
                        <p class="font-medium dark:text-white">{{ $client->email }}</p>
                    </div>
                </div>
                @endif

                @if($client->birth_date)
                <div class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Date de naissance</p>
                        <p class="font-medium dark:text-white">{{ $client->birth_date->format('d/m/Y') }}</p>
                    </div>
                </div>
                @endif
            </div>

            @if($client->notes)
            <!-- Notes -->
            <div class="mt-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Notes</h3>
                <div class="bg-gray-50 dark:bg-gray-700 p-4 rounded-lg">
                    <p class="text-gray-700 dark:text-gray-300 whitespace-pre-wrap">{{ $client->notes }}</p>
                </div>
            </div>
            @endif
    </x-card>

    <!-- Onglets pour les modules futurs -->
    <x-card>
        <div class="border-b border-gray-200 dark:border-gray-700">
            <nav class="-mb-px flex space-x-8 px-4 sm:px-6" aria-label="Tabs">
                <button class="border-blue-500 text-blue-600 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm" 
                        onclick="showTab('appointments')">
                    Séances
                </button>
                <button class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm" 
                        onclick="showTab('payments')">
                    Paiements
                </button>
            </nav>
        </div>

        <!-- Contenu des onglets -->
        <div class="p-4 sm:p-6">
            <!-- Onglet Séances -->
            <div id="appointments-tab" class="tab-content">
                @if($client->appointments->count() > 0)
                    <div class="mb-4">
                        <x-button href="{{ route('provider.appointments.calendar') }}">
                            + Nouvelle séance
                        </x-button>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Horaire</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Service</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Prix</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Statut</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Facturé</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                @foreach($client->appointments->sortByDesc('start_time') as $appointment)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">{{ $appointment->start_time->format('d/m/Y') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">{{ $appointment->start_time->format('H:i') }} - {{ $appointment->end_time->format('H:i') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">{{ $appointment->service->name ?? '-' }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold dark:text-white">{{ number_format($appointment->price_at_booking, 2) }} TND</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                            @switch($appointment->status)
                                                @case('scheduled')
                                                    <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">Programmé</span>
                                                    @break
                                                @case('completed')
                                                    <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Terminé</span>
                                                    @break
                                                @case('canceled')
                                                    <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Annulé</span>
                                                    @break
                                                @case('no_show')
                                                    <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">Absent</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                            @if($appointment->payments && $appointment->payments->count() > 0)
                                                <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">✓ Oui</span>
                                            @else
                                                <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">✗ Non</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4 text-sm text-gray-600 dark:text-gray-400">
                        Total séances : <span class="font-bold">{{ $client->appointments->count() }}</span>
                    </div>
                @else
                    <div class="text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucune séance pour le moment</h3>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Créez la première séance pour ce client.</p>
                        <div class="mt-6">
                            <x-button href="{{ route('provider.appointments.calendar') }}">
                                + Nouvelle séance
                            </x-button>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Onglet Paiements -->
            <div id="payments-tab" class="tab-content hidden">
                @if($client->payments && $client->payments->count() > 0)
                    <div class="mb-4">
                        <x-button href="{{ route('provider.payments.create', ['client_id' => $client->id]) }}">
                            + Nouvelle facture
                        </x-button>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Montant</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Méthode</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Référence</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                @foreach($client->payments->sortByDesc('payment_date') as $payment)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">{{ $payment->payment_date->format('d/m/Y') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold dark:text-white">{{ number_format($payment->amount, 2) }} {{ $payment->currency }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">
                                            @switch($payment->method)
                                                @case('cash') Espèces @break
                                                @case('card') Carte @break
                                                @case('bank_transfer') Virement @break
                                                @case('other') Autre @break
                                            @endswitch
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm dark:text-gray-300">{{ $payment->reference ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4 text-sm text-gray-600 dark:text-gray-400">
                        Total encaissé : <span class="font-bold">{{ number_format($client->payments->sum('amount'), 2) }} TND</span>
                    </div>
                @else
                    <div class="text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun paiement pour le moment</h3>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Enregistrez le premier paiement pour ce client.</p>
                        <div class="mt-6">
                            <x-button href="{{ route('provider.payments.create', ['client_id' => $client->id]) }}">
                                + Nouvelle facture
                            </x-button>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </x-card>
</div>

<script>
function showTab(tabName) {
    // Masquer tous les onglets
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.classList.add('hidden');
    });
    
    // Réinitialiser tous les boutons d'onglets
    document.querySelectorAll('nav button').forEach(btn => {
        btn.classList.remove('border-blue-500', 'text-blue-600');
        btn.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
    });
    
    // Afficher l'onglet sélectionné
    document.getElementById(tabName + '-tab').classList.remove('hidden');
    
    // Activer le bouton correspondant
    event.target.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
    event.target.classList.add('border-blue-500', 'text-blue-600');
}
</script>
@endsection
