@extends('layouts.provider')

@section('title', 'Tableau de bord')
@section('page-title', 'Tableau de bord')

@section('content')
<div class="space-y-6">

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 gap-4">
        <x-card class="text-center">
            <div class="text-2xl font-bold text-primary">{{ $appointmentsToday->count() }}</div>
            <div class="text-sm text-gray-600 dark:text-gray-400">RDV aujourd'hui</div>
        </x-card>
        
        <x-card class="text-center">
            <div class="text-2xl font-bold text-green-600">{{ number_format($totalPayments, 0, ',', ' ') }} {{ auth()->user()->provider->currency ?? 'TND' }}</div>
            <div class="text-sm text-gray-600 dark:text-gray-400">CA ce mois</div>
        </x-card>
    </div>

    <!-- Prochains RDV -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Prochains rendez-vous</h3>
        </x-slot>
        
        <div class="space-y-3">
            @if($nextAppointment)
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <div>
                        <div class="font-medium text-gray-900 dark:text-white">{{ $nextAppointment->client->full_name ?? 'N/A' }}</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">{{ $nextAppointment->service->name ?? 'N/A' }}</div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $nextAppointment->start_time->format('H:i') }}</div>
                        <div class="text-xs text-gray-500">{{ $nextAppointment->start_time->format('d/m') }}</div>
                    </div>
                </div>
            @else
                <p class="text-gray-500 text-center py-4">Aucun rendez-vous à venir</p>
            @endif
        </div>
    </x-card>

    <!-- Actions rapides -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Actions rapides</h3>
        </x-slot>
        
        <div class="grid grid-cols-2 gap-3">
            <x-button href="{{ route('provider.appointments.calendar') }}">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouveau RDV
            </x-button>

            <x-button href="{{ route('provider.clients.create') }}" variant="secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                Nouveau client
            </x-button>
        </div>
    </x-card>

</div>
@endsection
