@extends('layouts.provider')

@section('title', 'Types de Dépenses')

@section('content')
<div class="px-4 py-6 sm:px-6 lg:px-8">
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-4 sm:p-6">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-6 space-y-4 sm:space-y-0">
            <div>
                <h2 class="text-xl sm:text-2xl font-bold text-gray-900">Types de Dépenses</h2>
                <p class="text-sm text-gray-600 mt-1">Gérez vos catégories de dépenses</p>
            </div>
            <a href="{{ route('provider.expense-types.create') }}" 
               class="inline-flex items-center justify-center w-full sm:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors duration-200 shadow-sm">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouveau type
            </a>
        </div>

        <!-- Filtres -->
        <div class="mb-6">
            <form method="GET" action="{{ route('provider.expense-types.index') }}" class="flex flex-col sm:flex-row gap-4">
                <div class="flex-1">
                    <input type="text" name="search" value="{{ request('search') }}" 
                           placeholder="Rechercher par nom..."
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="flex gap-2">
                    <select name="status" class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Tous les statuts</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Actifs</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactifs</option>
                    </select>
                    <x-button type="submit" variant="secondary">
                        Filtrer
                    </x-button>
                    @if(request('search') || request('status'))
                        <x-button href="{{ route('provider.expense-types.index') }}" variant="secondary">
                            Effacer
                        </x-button>
                    @endif
                </div>
            </form>
        </div>

        @if($expenseTypes->count() > 0)
            <!-- Mobile cards -->
            <div class="block sm:hidden space-y-4">
                @foreach($expenseTypes as $expenseType)
                <div class="bg-gray-50 rounded-lg p-4 border {{ !$expenseType->is_active ? 'opacity-60' : '' }}">
                    <div class="flex justify-between items-start mb-3">
                        <div class="flex-1">
                            <div class="flex items-center mb-2">
                                @if($expenseType->color)
                                    <div class="w-4 h-4 rounded-full mr-2" style="background-color: {{ $expenseType->color }}"></div>
                                @endif
                                <h3 class="font-semibold text-gray-900">{{ $expenseType->name }}</h3>
                                @if(!$expenseType->is_active)
                                    <span class="ml-2 px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">Inactif</span>
                                @endif
                                @if($expenseType->is_default)
                                    <span class="ml-2 px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded-full">Par défaut</span>
                                @endif
                            </div>
                            @if($expenseType->description)
                                <p class="text-sm text-gray-500">{{ Str::limit($expenseType->description, 100) }}</p>
                            @endif
                        </div>
                        <div class="flex space-x-2 ml-4">
                            <a href="{{ route('provider.expense-types.edit', $expenseType->uuid) }}" 
                               class="bg-blue-100 text-blue-700 px-3 py-1 rounded text-sm font-medium hover:bg-blue-200">
                                Modifier
                            </a>
                            @if(!$expenseType->is_default)
                                <form action="{{ route('provider.expense-types.destroy', $expenseType->uuid) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="bg-red-100 text-red-700 px-3 py-1 rounded text-sm font-medium hover:bg-red-200" 
                                            onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce type de dépense ?')">
                                        Supprimer
                                    </button>
                                </form>
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Desktop table -->
            <div class="hidden sm:block overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Statut</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($expenseTypes as $expenseType)
                        <tr class="hover:bg-gray-50 {{ !$expenseType->is_active ? 'opacity-60' : '' }}">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    @if($expenseType->color)
                                        <div class="w-4 h-4 rounded-full mr-3" style="background-color: {{ $expenseType->color }}"></div>
                                    @endif
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $expenseType->name }}</div>
                                        @if($expenseType->is_default)
                                            <span class="text-xs text-blue-600">Par défaut</span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900">
                                {{ Str::limit($expenseType->description, 50) }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($expenseType->is_active)
                                    <span class="px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">Actif</span>
                                @else
                                    <span class="px-2 py-1 text-xs font-medium rounded-full bg-red-100 text-red-800">Inactif</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                <a href="{{ route('provider.expense-types.edit', $expenseType->uuid) }}" 
                                   class="text-blue-600 hover:text-blue-900">Modifier</a>
                                @if(!$expenseType->is_default)
                                    <form action="{{ route('provider.expense-types.destroy', $expenseType->uuid) }}" method="POST" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                                class="text-red-600 hover:text-red-900" 
                                                onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce type de dépense ?')">
                                            Supprimer
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                {{ $expenseTypes->appends(request()->query())->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012 2v2M7 7h10" />
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">Aucun type de dépense</h3>
                <p class="mt-1 text-sm text-gray-500">Commencez par créer votre premier type de dépense.</p>
                <div class="mt-6">
                    <a href="{{ route('provider.expense-types.create') }}" 
                       class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                        <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                        </svg>
                        Nouveau type
                    </a>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
