@extends('layouts.provider')

@section('title', 'Mes Dépenses')
@section('page-title', 'Mes Dépenses')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <x-card>
        <div class="flex justify-between items-center">
            <div>
                <h2 class="text-xl font-bold text-gray-900 dark:text-white">Mes Dépenses</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Gérez vos dépenses professionnelles</p>
            </div>
            <x-button href="{{ route('provider.expenses.create') }}" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouvelle
            </x-button>
        </div>
    </x-card>

    <!-- Filtres -->
    <x-card>
        <form method="GET" action="{{ route('provider.expenses.index') }}" class="space-y-4">
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                    <x-input name="search" :value="request('search')" placeholder="Rechercher..." />
                    <x-select name="expense_type_id">
                        <option value="">Tous les types</option>
                        @foreach($expenseTypes as $type)
                            <option value="{{ $type->id }}" {{ request('expense_type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->name }}
                            </option>
                        @endforeach
                    </x-select>
                    <x-select name="payment_method">
                        <option value="">Tous les modes</option>
                        <option value="cash" {{ request('payment_method') === 'cash' ? 'selected' : '' }}>Espèces</option>
                        <option value="card" {{ request('payment_method') === 'card' ? 'selected' : '' }}>Carte</option>
                        <option value="bank_transfer" {{ request('payment_method') === 'bank_transfer' ? 'selected' : '' }}>Virement</option>
                        <option value="other" {{ request('payment_method') === 'other' ? 'selected' : '' }}>Autre</option>
                    </x-select>
                    <x-select name="client_id">
                        <option value="">Tous les clients</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->full_name }}
                            </option>
                        @endforeach
                    </x-select>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <x-input type="date" name="date_from" :value="request('date_from')" />
                    <x-input type="date" name="date_to" :value="request('date_to')" />
                    <div class="flex gap-2">
                        <x-button type="submit" variant="secondary" class="flex-1">Filtrer</x-button>
                        @if(request()->hasAny(['search', 'expense_type_id', 'payment_method', 'client_id', 'date_from', 'date_to']))
                            <x-button href="{{ route('provider.expenses.index') }}" variant="secondary">Effacer</x-button>
                        @endif
                    </div>
                </div>
        </form>
    </x-card>

    @if($expenses->count() > 0)
        <!-- Mobile cards -->
        <div class="space-y-3">
            @foreach($expenses as $expense)
            <x-card>
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-center mb-2">
                            @if($expense->expenseType->color)
                                <div class="w-4 h-4 rounded-full mr-2" style="background-color: {{ $expense->expenseType->color }}"></div>
                            @endif
                            <h3 class="font-semibold text-gray-900 dark:text-white">{{ $expense->expenseType->name }}</h3>
                        </div>
                        <p class="text-lg font-bold text-gray-900 dark:text-white mb-1">{{ number_format($expense->amount, 2) }} {{ $expense->currency }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-1">{{ $expense->expense_date->format('d/m/Y') }}</p>
                        @if($expense->client)
                            <p class="text-sm text-blue-600">{{ $expense->client->full_name }}</p>
                        @endif
                        @if($expense->reference)
                            <p class="text-sm text-gray-500 dark:text-gray-400">Réf: {{ $expense->reference }}</p>
                        @endif
                    </div>
                    <div class="flex space-x-2">
                        <x-button href="{{ route('provider.expenses.edit', $expense->uuid) }}" variant="secondary" size="sm">Modifier</x-button>
                        <form action="{{ route('provider.expenses.destroy', $expense->uuid) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <x-button type="submit" variant="danger" size="sm" onclick="return confirm('Êtes-vous sûr de vouloir supprimer cette dépense ?')">Supprimer</x-button>
                        </form>
                    </div>
                </div>
            </x-card>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-6">
            {{ $expenses->appends(request()->query())->links() }}
        </div>
    @else
        <x-card class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucune dépense</h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Commencez par enregistrer votre première dépense.</p>
            <div class="mt-6">
                <x-button href="{{ route('provider.expenses.create') }}">
                    <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    Nouvelle dépense
                </x-button>
            </div>
        </x-card>
    @endif
</div>
@endsection
