@extends('layouts.provider')

@section('title', 'Finances')
@section('page-title', 'Finances')

@section('content')
<div class="space-y-6">
    @php
        $currentTab = request('tab', 'synthese');
    @endphp
    
    <x-finances-tabs active="{{ $currentTab }}" />

    @if($currentTab === 'synthese')
    <!-- Onglet Synthèse -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Synthèse financière</h3>
        </x-slot>
        
        <div class="space-y-6">
            <!-- Filtres de période -->
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <input type="hidden" name="tab" value="synthese">
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        type="date" 
                        name="start_date" 
                        label="Du" 
                        value="{{ $startDate->format('Y-m-d') }}"
                    />
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        type="date" 
                        name="end_date" 
                        label="Au" 
                        value="{{ $endDate->format('Y-m-d') }}"
                    />
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.finances.index') }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>

            <!-- Stats Cards -->
            <div class="space-y-4">
                <div class="flex gap-4">
                    <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg p-4 text-center flex-1">
                        <div class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ number_format($totalPayments, 2) }} {{ $currency }}</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400 mt-1">Total Factures</div>
                    </div>
                    
                    <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg p-4 text-center flex-1">
                        <div class="text-2xl font-bold text-red-600 dark:text-red-400">{{ number_format($totalExpenses, 2) }} {{ $currency }}</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400 mt-1">Total Dépenses</div>
                    </div>
                </div>
                
                <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg p-4 text-center">
                    <div class="text-2xl font-bold {{ $balanceNet >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">{{ number_format($balanceNet, 2) }} {{ $currency }}</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400 mt-1">Solde Net</div>
                </div>
            </div>
            
            <!-- Actions rapides -->
            <div>
                <h4 class="text-md font-semibold text-gray-900 dark:text-white mb-3">Actions rapides</h4>
                <div class="grid grid-cols-2 gap-3">
                    <x-button href="{{ route('provider.payments.create') }}">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Nouvelle facture
                    </x-button>

                    <x-button href="{{ route('provider.expenses.create') }}" variant="secondary">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Nouvelle dépense
                    </x-button>
                </div>
            </div>
        </div>
    </x-card>

    @elseif($currentTab === 'factures')
    <!-- Onglet Factures -->
    <x-card>
        <x-slot name="header">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Factures ({{ $payments->total() }})</h3>
                <x-button href="{{ route('provider.payments.create') }}" size="sm">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Nouvelle
                </x-button>
            </div>
        </x-slot>
        
        <div class="space-y-6">
            <!-- Filtres -->
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <input type="hidden" name="tab" value="factures">
                <div class="flex-1 min-w-[140px]">
                    <x-select name="client_id" label="Client">
                        <option value="">Tous</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->full_name }}
                            </option>
                        @endforeach
                    </x-select>
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-select name="method" label="Méthode">
                        <option value="">Toutes</option>
                        <option value="cash" {{ request('method') == 'cash' ? 'selected' : '' }}>Espèces</option>
                        <option value="card" {{ request('method') == 'card' ? 'selected' : '' }}>Carte</option>
                        <option value="bank_transfer" {{ request('method') == 'bank_transfer' ? 'selected' : '' }}>Virement</option>
                    </x-select>
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.finances.index', ['tab' => 'factures']) }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>

            @if($payments->count() > 0)
            <div class="space-y-3">
                @foreach($payments as $payment)
                    <x-card class="hover:shadow-md transition-shadow">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <div class="font-semibold text-gray-900 dark:text-white">{{ $payment->client->full_name ?? 'N/A' }}</div>
                                <div class="text-sm text-gray-600 dark:text-gray-400">{{ $payment->payment_date->format('d/m/Y') }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    @switch($payment->method)
                                        @case('cash') Espèces @break
                                        @case('card') Carte @break
                                        @case('bank_transfer') Virement @break
                                        @default {{ $payment->method ?? '-' }}
                                    @endswitch
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-green-600">{{ number_format($payment->amount, 2) }} {{ $currency }}</div>
                                <div class="flex space-x-2 mt-2">
                                    <x-button href="{{ route('provider.payments.edit', $payment->uuid) }}" variant="secondary" size="sm">
                                        Éditer
                                    </x-button>
                                    <x-button href="#" variant="secondary" size="sm">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </x-button>
                                </div>
                            </div>
                        </div>
                    </x-card>
                @endforeach
            </div>
                <div class="mt-6">
                    {{ $payments->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucune facture</h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Aucune facture pour cette période.</p>
                </div>
            @endif
        </div>
    </x-card>

    @elseif($currentTab === 'depenses')
    <!-- Onglet Dépenses -->
    <x-card>
        <x-slot name="header">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Dépenses ({{ $expenses->total() }})</h3>
                <x-button href="{{ route('provider.expenses.create') }}" size="sm">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Nouvelle
                </x-button>
            </div>
        </x-slot>
        
        <div class="space-y-6">
            <!-- Filtres -->
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <input type="hidden" name="tab" value="depenses">
                <div class="flex-1 min-w-[140px]">
                    <x-select name="expense_type_id" label="Type">
                        <option value="">Tous</option>
                        @foreach($expenseTypes as $type)
                            <option value="{{ $type->id }}" {{ request('expense_type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->name }}
                            </option>
                        @endforeach
                    </x-select>
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-select name="supplier_id" label="Fournisseur">
                        <option value="">Tous</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                {{ $supplier->name }}
                            </option>
                        @endforeach
                    </x-select>
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-select name="payment_method" label="Méthode">
                        <option value="">Toutes</option>
                        <option value="cash" {{ request('payment_method') == 'cash' ? 'selected' : '' }}>Espèces</option>
                        <option value="card" {{ request('payment_method') == 'card' ? 'selected' : '' }}>Carte</option>
                        <option value="bank_transfer" {{ request('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Virement</option>
                    </x-select>
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.finances.index', ['tab' => 'depenses']) }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>

            @if($expenses->count() > 0)
            <div class="space-y-3">
                @foreach($expenses as $expense)
                    <x-card class="hover:shadow-md transition-shadow">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <div class="font-semibold text-gray-900 dark:text-white">
                                    {{ $expense->expenseType->name ?? 'N/A' }}
                                    @if($expense->supplier)
                                        <span class="text-xs font-normal text-gray-500 dark:text-gray-400">· {{ $expense->supplier->name }}</span>
                                    @endif
                                </div>
                                <div class="text-sm text-gray-600 dark:text-gray-400">{{ $expense->expense_date->format('d/m/Y') }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    @switch($expense->payment_method)
                                        @case('cash') Espèces @break
                                        @case('card') Carte @break
                                        @case('bank_transfer') Virement @break
                                        @default {{ $expense->payment_method ?? '-' }}
                                    @endswitch
                                </div>
                                @if($expense->notes)
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ Str::limit($expense->notes, 50) }}</div>
                                @endif
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-red-600">-{{ number_format($expense->amount, 2) }} {{ $currency }}</div>
                                <div class="flex gap-2 mt-2">
                                    <x-button href="{{ route('provider.expenses.edit', $expense->uuid) }}" variant="secondary" size="sm">
                                        Éditer
                                    </x-button>
                                    <x-delete-confirm 
                                        :action="route('provider.expenses.destroy', $expense->uuid)" 
                                        message="Êtes-vous sûr de vouloir supprimer cette dépense ?"
                                    />
                                </div>
                            </div>
                        </div>
                    </x-card>
                @endforeach
            </div>
            @else
                <div class="text-center py-12">
                    <h3 class="text-sm font-medium text-gray-900 dark:text-white">Aucune dépense</h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Aucune dépense pour cette période.</p>
                </div>
            @endif
        </div>
    </x-card>

    @elseif($currentTab === 'types-depense')
    <!-- Onglet Types -->
    <x-card>
        <x-slot name="header">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Types de dépenses ({{ $expenseTypes->count() }})</h3>
                <x-button href="{{ route('provider.expense-types.create') }}" size="sm">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Nouveau
                </x-button>
            </div>
        </x-slot>
        
        <div class="space-y-6">
            <!-- Filtres -->
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <input type="hidden" name="tab" value="types-depense">
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        name="search" 
                        label="Recherche" 
                        :value="request('search')" 
                        placeholder="Nom ou description..."
                    />
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-select name="status" label="Statut">
                        <option value="">Tous</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Actifs</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactifs</option>
                    </x-select>
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.finances.index', ['tab' => 'types-depense']) }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>

            @if($expenseTypes->count() > 0)
            <div class="space-y-3">
                @foreach($expenseTypes as $type)
                    <x-card>
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-900 dark:text-white">{{ $type->name }}</h4>
                                @if($type->description)
                                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $type->description }}</p>
                                @endif
                                @if($type->expenses_count > 0)
                                    <p class="text-xs text-blue-600 dark:text-blue-400 mt-1">Utilisé dans {{ $type->expenses_count }} dépense(s)</p>
                                @endif
                            </div>
                            <div class="flex gap-2">
                                <x-button href="{{ route('provider.expense-types.edit', $type->uuid) }}" variant="secondary" size="sm">
                                    Éditer
                                </x-button>
                                @if($type->expenses_count == 0 && !$type->is_default)
                                    <x-delete-confirm 
                                        :action="route('provider.expense-types.destroy', $type->uuid)" 
                                        message="Êtes-vous sûr de vouloir supprimer ce type de dépense ?"
                                    />
                                @endif
                            </div>
                        </div>
                    </x-card>
                @endforeach
            </div>
            @else
                <div class="text-center py-12">
                    <h3 class="text-sm font-medium text-gray-900 dark:text-white">Aucun type</h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Créez votre premier type de dépense.</p>
                </div>
            @endif
        </div>
    </x-card>
    @endif
</div>


@endsection
