<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prestataire - @yield('title')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navigation mobile-first -->
    <nav class="bg-white shadow-sm border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo et titre -->
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <span class="text-lg sm:text-xl font-bold text-gray-900">{{ auth()->user()->provider->business_name ?? 'Mon Espace' }}</span>
                    </div>
                    
                    <!-- Navigation desktop -->
                    <div class="hidden md:ml-8 md:flex md:space-x-6">
                        <a href="{{ route('provider.dashboard') }}" 
                           class="{{ request()->routeIs('provider.dashboard') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Tableau de bord
                        </a>
                        <a href="{{ route('provider.clients.index') }}" 
                           class="{{ request()->routeIs('provider.clients.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Mes Clients
                        </a>
                        <a href="{{ route('provider.services.index') }}" 
                           class="{{ request()->routeIs('provider.services.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Mes Services
                        </a>
                        <a href="{{ route('provider.appointments.calendar') }}" 
                           class="{{ request()->routeIs('provider.appointments.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Calendrier
                        </a>
                        <a href="{{ route('provider.payments.index') }}" 
                           class="{{ request()->routeIs('provider.payments.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Factures
                        </a>
                        <a href="{{ route('provider.expenses.index') }}" 
                           class="{{ request()->routeIs('provider.expenses.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Dépenses
                        </a>
                        <a href="{{ route('provider.expense-types.index') }}" 
                           class="{{ request()->routeIs('provider.expense-types.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Types de dépenses
                        </a>
                        <a href="{{ route('provider.profile.edit') }}" 
                           class="{{ request()->routeIs('provider.profile.*') ? 'text-blue-600 border-blue-600' : 'text-gray-500 border-transparent hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors">
                            Mon Profil
                        </a>
                    </div>
                </div>

                <!-- Actions utilisateur -->
                <div class="flex items-center space-x-4">
                    <!-- Menu mobile -->
                    <div class="md:hidden">
                        <button type="button" id="mobile-menu-button" 
                                class="text-gray-500 hover:text-gray-700 focus:outline-none focus:text-gray-700 transition-colors">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                        </button>
                    </div>
                    
                    <!-- Déconnexion -->
                    <form method="POST" action="{{ route('logout') }}" class="hidden md:block">
                        @csrf
                        <button type="submit" 
                                class="text-gray-500 hover:text-gray-700 font-medium text-sm transition-colors">
                            Déconnexion
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Menu mobile -->
        <div id="mobile-menu" class="hidden md:hidden border-t border-gray-200 bg-gray-50">
            <div class="px-4 py-3 space-y-2">
                <a href="{{ route('provider.dashboard') }}" 
                   class="{{ request()->routeIs('provider.dashboard') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Tableau de bord
                </a>
                <a href="{{ route('provider.clients.index') }}" 
                   class="{{ request()->routeIs('provider.clients.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Mes Clients
                </a>
                <a href="{{ route('provider.services.index') }}" 
                   class="{{ request()->routeIs('provider.services.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Mes Services
                </a>
                <a href="{{ route('provider.appointments.calendar') }}" 
                   class="{{ request()->routeIs('provider.appointments.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Calendrier
                </a>
                <a href="{{ route('provider.payments.index') }}" 
                   class="{{ request()->routeIs('provider.payments.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Factures
                </a>
                <a href="{{ route('provider.expenses.index') }}" 
                   class="{{ request()->routeIs('provider.expenses.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Dépenses
                </a>
                <a href="{{ route('provider.expense-types.index') }}" 
                   class="{{ request()->routeIs('provider.expense-types.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Types de dépenses
                </a>
                <a href="{{ route('provider.profile.edit') }}" 
                   class="{{ request()->routeIs('provider.profile.*') ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-100' }} block px-3 py-2 rounded-md text-sm font-medium transition-colors">
                    Mon Profil
                </a>
                <form method="POST" action="{{ route('logout') }}" class="pt-2 border-t border-gray-200">
                    @csrf
                    <button type="submit" 
                            class="w-full text-left px-3 py-2 text-gray-700 hover:bg-gray-100 rounded-md text-sm font-medium transition-colors">
                        Déconnexion
                    </button>
                </form>
            </div>
        </div>
    </nav>

    <!-- Contenu principal -->
    <main>
        <!-- Messages flash -->
        @if(session('success'))
            <div class="mx-4 sm:mx-6 lg:mx-8 mt-6 sm:mt-8 mb-6 bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg shadow-sm">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    {{ session('success') }}
                </div>
            </div>
        @endif
        
        @if(session('error'))
            <div class="mx-4 sm:mx-6 lg:mx-8 mt-6 sm:mt-8 mb-6 bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg shadow-sm">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                    {{ session('error') }}
                </div>
            </div>
        @endif
        
        @yield('content')
    </main>

    <!-- Script pour le menu mobile -->
    <script>
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });
    </script>
</body>
</html>
