<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture {{ $payment->reference }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; color: #333; margin: 0; padding: 20px; }
        .header { margin-bottom: 30px; border-bottom: 2px solid #2563eb; padding-bottom: 20px; }
        .company-info { margin-bottom: 20px; }
        .company-name { font-size: 20px; font-weight: bold; color: #1e40af; margin-bottom: 5px; }
        .invoice-title { font-size: 24px; font-weight: bold; color: #1e40af; text-align: right; margin-top: -60px; }
        .invoice-details { text-align: right; margin-bottom: 30px; }
        .client-info { background: #f3f4f6; padding: 15px; margin-bottom: 30px; border-radius: 5px; }
        .section-title { font-size: 14px; font-weight: bold; margin-bottom: 10px; color: #1e40af; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th { background: #2563eb; color: white; padding: 10px; text-align: left; }
        td { padding: 10px; border-bottom: 1px solid #e5e7eb; }
        .total-row { font-weight: bold; font-size: 16px; background: #f3f4f6; }
        .footer { margin-top: 50px; padding-top: 20px; border-top: 1px solid #e5e7eb; font-size: 10px; color: #6b7280; text-align: center; }
        .notes { background: #fef3c7; padding: 15px; border-left: 4px solid #f59e0b; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-info">
            <div class="company-name">{{ $provider->legal_name ?? $provider->business_name }}</div>
            @if($provider->tax_id)
                <div>Matricule fiscal : {{ $provider->tax_id }}</div>
            @endif
            @if($provider->address)
                <div>{{ $provider->address }}</div>
            @endif
            @if($provider->city || $provider->country)
                <div>{{ $provider->city }}{{ $provider->city && $provider->country ? ', ' : '' }}{{ $provider->country }}</div>
            @endif
        </div>
        <div class="invoice-title">FACTURE</div>
    </div>

    <div class="invoice-details">
        <div><strong>N° Facture :</strong> {{ $payment->reference }}</div>
        <div><strong>Date :</strong> {{ $payment->payment_date->format('d/m/Y') }}</div>
    </div>

    @if($payment->client)
    <div class="client-info">
        <div class="section-title">Client</div>
        <div><strong>{{ $payment->client->full_name }}</strong></div>
        @if($payment->client->phone)
            <div>Tél : {{ $payment->client->phone }}</div>
        @endif
        @if($payment->client->email)
            <div>Email : {{ $payment->client->email }}</div>
        @endif
        @if($payment->client->address)
            <div>{{ $payment->client->address }}</div>
        @endif
    </div>
    @endif

    <div class="section-title">Détails de la facture</div>
    <table>
        <thead>
            <tr>
                <th>Description</th>
                <th style="text-align: right; width: 150px;">Montant</th>
            </tr>
        </thead>
        <tbody>
            @if($payment->appointments && $payment->appointments->count() > 0)
                @foreach($payment->appointments as $appointment)
                    <tr>
                        <td>
                            {{ $appointment->service->name ?? 'Service' }}<br>
                            <small style="color: #6b7280;">{{ $appointment->start_time->format('d/m/Y H:i') }}</small>
                        </td>
                        <td style="text-align: right;">{{ number_format($appointment->price_at_booking, 2) }} {{ $appointment->currency }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>Prestation de service</td>
                    <td style="text-align: right;">{{ number_format($payment->amount, 2) }} {{ $payment->currency }}</td>
                </tr>
            @endif
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td>TOTAL</td>
                <td style="text-align: right;">{{ number_format($payment->amount, 2) }} {{ $payment->currency }}</td>
            </tr>
        </tfoot>
    </table>

    <div>
        <strong>Méthode de paiement :</strong>
        @switch($payment->method)
            @case('cash') Espèces @break
            @case('card') Carte bancaire @break
            @case('bank_transfer') Virement bancaire @break
            @case('other') Autre @break
        @endswitch
    </div>

    @if($payment->notes)
    <div class="notes">
        <strong>Notes :</strong><br>
        {{ $payment->notes }}
    </div>
    @endif

    <div class="footer">
        <div>Facture générée le {{ now()->format('d/m/Y à H:i') }}</div>
        <div>{{ $provider->business_name }} - Tous droits réservés</div>
    </div>
</body>
</html>
