@extends('layouts.provider')

@section('title', 'Profil')
@section('page-title', 'Profil')

@section('content')
<div class="space-y-6 pb-24">

    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Informations personnelles</h3>
        </x-slot>
        
        <form action="{{ route('provider.profile.update') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PUT')
            
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                <x-input 
                    type="text" 
                    name="name" 
                    label="Nom complet" 
                    value="{{ old('name', auth()->user()->name) }}"
                    required
                />

                <x-input 
                    type="email" 
                    name="email" 
                    label="Email" 
                    value="{{ old('email', auth()->user()->email) }}"
                    required
                />

                <x-input 
                    type="password" 
                    name="password" 
                    label="Nouveau mot de passe" 
                    placeholder="Laisser vide pour ne pas changer"
                    autocomplete="new-password"
                />

                <x-input 
                    type="password" 
                    name="password_confirmation" 
                    label="Confirmer le mot de passe" 
                    placeholder="Confirmer le nouveau mot de passe"
                    autocomplete="new-password"
                />
            </div>
    </x-card>

    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Informations professionnelles</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div class="sm:col-span-2">
                <x-input 
                    type="text" 
                    name="business_name" 
                    label="Nom commercial" 
                    value="{{ old('business_name', $provider->business_name) }}"
                    required
                />
            </div>

            <x-input 
                type="tel" 
                name="phone" 
                label="Téléphone" 
                value="{{ old('phone', $provider->phone) }}"
                required
            />

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Logo</label>
                @if($provider->logo)
                    <div class="mb-3 flex items-center space-x-3">
                        <img src="{{ asset('storage/' . $provider->logo) }}" alt="Logo actuel" 
                             class="h-16 w-16 object-cover rounded-lg border border-gray-200 dark:border-gray-600">
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">Logo actuel</p>
                            <label class="flex items-center">
                                <input type="checkbox" name="remove_logo" value="1" class="mr-2 h-4 w-4 text-primary border-gray-300 rounded focus:ring-primary">
                                <span class="text-sm text-red-600 dark:text-red-400">Supprimer le logo</span>
                            </label>
                        </div>
                    </div>
                @endif
                <input type="file" name="logo" accept="image/*"
                       class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-primary focus:border-primary bg-white dark:bg-gray-800 text-gray-900 dark:text-white file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-primary/10 file:text-primary hover:file:bg-primary/20">
                @error('logo')<span class="text-red-500 text-xs mt-1 block">{{ $message }}</span>@enderror
            </div>
        </div>
    </x-card>

    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Adresse (optionnel)</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            <div class="sm:col-span-2">
                <x-input 
                    type="text" 
                    name="address" 
                    label="Adresse" 
                    value="{{ old('address', $provider->address) }}"
                />
            </div>

            <x-input 
                type="text" 
                name="city" 
                label="Ville" 
                value="{{ old('city', $provider->city) }}"
            />

            <x-input 
                type="text" 
                name="country" 
                label="Pays" 
                value="{{ old('country', $provider->country) }}"
            />
        </div>
    </x-card>

    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Description de votre activité</h3>
        </x-slot>
        
        <x-textarea 
            name="description" 
            rows="4"
            placeholder="Décrivez vos services et votre expertise..."
            value="{{ old('description', $provider->description) }}"
        />
    </x-card>

    <!-- Bouton fixe au-dessus de la navigation du bas -->
    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <x-button type="submit" class="w-full">
            Enregistrer les modifications
        </x-button>
    </div>
    </form>
</div>
@endsection

