@extends('layouts.provider')

@section('title', isset($service) ? 'Modifier le Service' : 'Nouveau Service')
@section('page-title', 'Paramètres > Services & Tarifs')

@section('content')
<x-card>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ isset($service) ? 'Modifier le service' : 'Nouveau service' }}</h3>
            <x-button href="{{ route('provider.services.index') }}" variant="secondary" size="sm">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Retour
            </x-button>
        </div>
    </x-slot>

<form action="{{ isset($service) ? route('provider.services.update', $service->uuid) : route('provider.services.store') }}" method="POST" class="space-y-6 pb-24">
    @csrf
    @if(isset($service))
        @method('PUT')
    @endif
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="md:col-span-2">
            <x-input 
                name="name" 
                label="Nom du service" 
                :value="old('name', $service->name ?? '')" 
                placeholder="Ex: Massage relaxant, Coaching sportif..."
                error="{{ $errors->first('name') }}"
                required />
        </div>

        <x-input 
            type="number" 
            name="duration_minutes" 
            label="Durée (minutes)" 
            :value="old('duration_minutes', $service->duration_minutes ?? 60)" 
            min="1" 
            max="1440" 
            error="{{ $errors->first('duration_minutes') }}"
            required />

        <x-input 
            type="number" 
            name="base_price" 
            label="Prix de base" 
            :value="old('base_price', $service->base_price ?? '')" 
            step="0.01" 
            min="0" 
            error="{{ $errors->first('base_price') }}"
            required />

        <div class="md:col-span-2">
            <x-textarea 
                name="description" 
                label="Description" 
                :value="old('description', $service->description ?? '')" 
                placeholder="Décrivez votre service, les bénéfices, ce qui est inclus..."
                rows="4" />
        </div>

        <div>
            <label class="block text-gray-700 dark:text-gray-300 text-sm font-medium mb-2">Couleur (optionnel)</label>
            <div class="flex items-center space-x-3">
                <input type="color" name="color" value="{{ old('color', $service->color ?? '#3C50E0') }}" 
                       class="w-12 h-10 border border-gray-300 dark:border-gray-600 rounded cursor-pointer">
                <input type="text" name="color_text" value="{{ old('color', $service->color ?? '#3C50E0') }}" 
                       class="flex-1 px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 bg-white dark:bg-gray-800 text-gray-900 dark:text-white transition-colors"
                       placeholder="#3C50E0">
            </div>
            @error('color')<span class="text-red-500 text-xs mt-1 block">{{ $message }}</span>@enderror
        </div>

        <div class="flex items-center">
            <div class="flex items-center h-5">
                <input type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $service->is_active ?? true) ? 'checked' : '' }} class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded">
            </div>
            <div class="ml-3">
                <label for="is_active" class="text-sm font-medium text-gray-700 dark:text-gray-300">Service actif</label>
                <p class="text-sm text-gray-500 dark:text-gray-400">Ce service sera disponible lors de la création de rendez-vous</p>
            </div>
        </div>
    </div>

    <!-- Bouton fixe au-dessus de la navigation du bas -->
    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <div class="flex gap-3">
            <x-button href="{{ route('provider.services.index') }}" variant="secondary" class="flex-1">
                Annuler
            </x-button>
            <x-button type="submit" variant="primary" class="flex-1">
                {{ isset($service) ? 'Enregistrer les modifications' : 'Créer le service' }}
            </x-button>
        </div>
    </div>
</form>
</x-card>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const colorPicker = document.querySelector('input[name="color"]');
    const colorText = document.querySelector('input[name="color_text"]');
    
    colorPicker.addEventListener('change', function() {
        colorText.value = this.value;
    });
    
    colorText.addEventListener('input', function() {
        if (/^#[0-9A-F]{6}$/i.test(this.value)) {
            colorPicker.value = this.value;
        }
    });
});
</script>
@endsection
