@extends('layouts.provider')

@section('title', 'Paramètres - Services & Tarifs')
@section('page-title', 'Paramètres')

@section('content')
<div class="space-y-6">
    <x-settings-tabs active="services" />

    <x-card>
        <x-slot name="header">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Services & Tarifs ({{ $services->total() }})</h3>
                <x-button href="{{ route('provider.services.create') }}" size="sm">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Nouveau
                </x-button>
            </div>
        </x-slot>

        <!-- Filtres -->
        <div class="mb-6">
            <form method="GET" action="{{ route('provider.services.index') }}" class="flex flex-wrap gap-3 items-end">
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        name="search" 
                        label="Recherche" 
                        :value="request('search')" 
                        placeholder="Nom du service..."
                    />
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-select name="status" label="Statut">
                        <option value="">Tous</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Actifs</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactifs</option>
                    </x-select>
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.services.index') }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>
        </div>

    @if($services->count() > 0)
        <div class="space-y-3">
            @foreach($services as $service)
                <x-card class="hover:shadow-md transition-shadow {{ !$service->is_active ? 'opacity-60' : '' }}">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center mb-2">
                                @if($service->color)
                                    <div class="w-4 h-4 rounded-full mr-2" style="background-color: {{ $service->color }}"></div>
                                @endif
                                <div class="font-semibold text-gray-900 dark:text-white">{{ $service->name }}</div>
                                @if(!$service->is_active)
                                    <span class="ml-2 px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">Inactif</span>
                                @endif
                            </div>
                            @if($service->description)
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ Str::limit($service->description, 100) }}</div>
                            @endif
                        </div>
                        <div class="text-right">
                            <div class="text-sm text-gray-600 dark:text-gray-400 mb-2">{{ $service->formatted_duration }} • {{ $service->formatted_price }}</div>
                            <div class="flex gap-2 justify-end">
                                <x-button href="{{ route('provider.services.edit', $service->uuid) }}" variant="secondary" size="sm">
                                    Éditer
                                </x-button>
                                @if($service->appointments_count == 0)
                                    <x-delete-confirm 
                                        :action="route('provider.services.destroy', $service->uuid)" 
                                        message="Êtes-vous sûr de vouloir supprimer ce service ?"
                                    />
                                @else
                                    <span class="inline-flex items-center justify-center w-8 h-8 text-gray-400 cursor-not-allowed" 
                                          title="Ce service ne peut pas être supprimé car il est utilisé dans des rendez-vous">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                        </svg>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </x-card>
            @endforeach
        </div>
        <div class="mt-6">
            {{ $services->appends(request()->query())->links() }}
        </div>
    @else
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun service</h3>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Commencez par créer votre premier service.</p>
            </div>
        @endif
    </x-card>
</div>
@endsection
