@extends('layouts.provider')

@section('title', 'Paramètres - Informations Fiscales')
@section('page-title', 'Paramètres')

@section('content')
<x-settings-tabs active="fiscal" />

<form action="{{ route('provider.settings.fiscal.update') }}" method="POST" class="space-y-6 pb-24">
    @csrf
    @method('PUT')
    
    <!-- Informations fiscales -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Informations fiscales</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="md:col-span-2">
                <x-input 
                    name="legal_name" 
                    label="Raison sociale officielle" 
                    :value="old('legal_name', $provider->legal_name)" 
                    placeholder="Si différente du nom commercial"
                    help="Laissez vide si identique au nom commercial" />
            </div>

            <x-input 
                name="tax_id" 
                label="Matricule fiscal" 
                :value="old('tax_id', $provider->tax_id)" 
                placeholder="Ex: 1234567/A/M/000" />

            <!-- Note sur l'adresse -->
            <div class="md:col-span-2">
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <div class="flex">
                        <svg class="w-5 h-5 text-blue-400 dark:text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                        <div>
                            <p class="text-sm text-blue-700 dark:text-blue-300 font-medium mb-1">
                                Adresse de facturation
                            </p>
                            <p class="text-sm text-blue-600 dark:text-blue-400">
                                L'adresse de facturation est la même que votre adresse de profil. 
                                <a href="{{ route('provider.profile.edit') }}" class="underline font-medium">
                                    Modifiez-la dans votre profil
                                </a> pour qu'elle apparaisse sur vos factures.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </x-card>

    <!-- Aperçu sur facture -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Aperçu sur facture</h3>
        </x-slot>
        
        <div class="bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg p-6">
            <div class="text-sm space-y-1">
                <div class="font-semibold text-gray-900 dark:text-white">
                    {{ $provider->legal_name ?: $provider->business_name ?: 'Nom de l\'entreprise' }}
                </div>
                @if($provider->tax_id)
                    <div class="text-gray-600 dark:text-gray-400">
                        Matricule fiscal: {{ $provider->tax_id }}
                    </div>
                @endif
                @if($provider->address)
                    <div class="text-gray-600 dark:text-gray-400">
                        {{ $provider->address }}
                    </div>
                @endif
                @if($provider->city || $provider->country)
                    <div class="text-gray-600 dark:text-gray-400">
                        {{ trim(($provider->city ?? '') . ' ' . ($provider->country ?? '')) }}
                    </div>
                @endif
                @if($provider->phone)
                    <div class="text-gray-600 dark:text-gray-400">
                        Tél: {{ $provider->phone }}
                    </div>
                @endif
            </div>
        </div>
        <p class="mt-4 text-sm text-gray-500 dark:text-gray-400">
            Cet aperçu montre comment vos informations apparaîtront sur vos factures.
        </p>
    </x-card>
    
    <!-- Bouton fixe au-dessus de la navigation du bas -->
    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <x-button type="submit" variant="primary" class="w-full">
            Enregistrer
        </x-button>
    </div>
</form>
@endsection
