@extends('layouts.provider')

@section('title', 'Paramètres - Paramètres Généraux')
@section('page-title', 'Paramètres')

@section('content')
<x-settings-tabs active="general" />

<form action="{{ route('provider.settings.general.update') }}" method="POST" class="space-y-6 pb-24">
    @csrf
    @method('PUT')
    
    <!-- Section Général -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Paramètres généraux</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            @php
                $selectedLanguage = old('language', $provider->general_settings['language'] ?? '');
                $selectedTimezone = old('timezone', $provider->general_settings['timezone'] ?? '');
            @endphp
            <x-select 
                name="language" 
                label="Langue">
                <option value="" {{ $selectedLanguage === '' ? 'selected' : '' }}>Sélectionner une langue</option>
                <option value="fr" {{ $selectedLanguage === 'fr' ? 'selected' : '' }}>Français</option>
                <option value="ar" {{ $selectedLanguage === 'ar' ? 'selected' : '' }}>العربية</option>
                <option value="en" {{ $selectedLanguage === 'en' ? 'selected' : '' }}>English</option>
            </x-select>

            <x-select 
                name="timezone" 
                label="Fuseau horaire">
                <option value="" {{ $selectedTimezone === '' ? 'selected' : '' }}>Sélectionner un fuseau</option>
                <option value="Africa/Tunis" {{ $selectedTimezone === 'Africa/Tunis' ? 'selected' : '' }}>Africa/Tunis</option>
                <option value="Europe/Paris" {{ $selectedTimezone === 'Europe/Paris' ? 'selected' : '' }}>Europe/Paris</option>
                <option value="UTC" {{ $selectedTimezone === 'UTC' ? 'selected' : '' }}>UTC</option>
            </x-select>

            @php
                $selectedCurrency = old('default_currency', $provider->general_settings['default_currency'] ?? '');
            @endphp
            <x-select 
                name="default_currency" 
                label="Devise par défaut">
                <option value="" {{ $selectedCurrency === '' ? 'selected' : '' }}>Sélectionner une devise</option>
                <option value="TND" {{ $selectedCurrency === 'TND' ? 'selected' : '' }}>TND - Dinar Tunisien</option>
                <option value="EUR" {{ $selectedCurrency === 'EUR' ? 'selected' : '' }}>EUR - Euro</option>
                <option value="USD" {{ $selectedCurrency === 'USD' ? 'selected' : '' }}>USD - Dollar US</option>
            </x-select>

            @php
                $selectedFirstDay = old('first_day_of_week', $provider->general_settings['first_day_of_week'] ?? '0');
            @endphp
            <x-select 
                name="first_day_of_week" 
                label="Premier jour de la semaine">
                <option value="0" {{ $selectedFirstDay == '0' ? 'selected' : '' }}>Dimanche</option>
                <option value="1" {{ $selectedFirstDay == '1' ? 'selected' : '' }}>Lundi</option>
            </x-select>

            <div class="md:col-span-2">
                @php
                    $selectedCalendarView = old('default_calendar_view', $provider->general_settings['default_calendar_view'] ?? 'day');
                @endphp
                <x-select 
                    name="default_calendar_view" 
                    label="Vue par défaut du calendrier">
                    <option value="day" {{ $selectedCalendarView === 'day' ? 'selected' : '' }}>Jour</option>
                    <option value="week" {{ $selectedCalendarView === 'week' ? 'selected' : '' }}>Semaine</option>
                    <option value="month" {{ $selectedCalendarView === 'month' ? 'selected' : '' }}>Mois</option>
                </x-select>
            </div>
        </div>
    </x-card>

    <!-- Section Calendrier -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Paramètres du calendrier</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Jours de repos -->
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                    Jours de repos par défaut
                </label>
                <div class="grid grid-cols-2 sm:grid-cols-4 lg:grid-cols-7 gap-3">
                    @php
                        $days = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
                        $selectedDaysOff = old('days_off', $provider->calendar_settings['days_off'] ?? []);
                        // Convertir en chaînes pour la comparaison
                        $selectedDaysOff = array_map('strval', $selectedDaysOff);
                    @endphp
                    @foreach($days as $index => $day)
                        <div class="flex items-center">
                            <input type="checkbox" 
                                   id="day_{{ $index }}" 
                                   name="days_off[]" 
                                   value="{{ $index }}"
                                   {{ in_array((string)$index, $selectedDaysOff, true) ? 'checked' : '' }}
                                   class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 dark:border-gray-600 rounded">
                            <label for="day_{{ $index }}" class="ml-2 text-sm text-gray-700 dark:text-gray-300">
                                {{ $day }}
                            </label>
                        </div>
                    @endforeach
                </div>
                @error('days_off')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            @php
                $selectedSlotDuration = old('slot_duration_minutes', $provider->calendar_settings['slot_duration_minutes'] ?? '');
            @endphp
            <x-select 
                name="slot_duration_minutes" 
                label="Durée des créneaux (minutes)">
                <option value="" {{ $selectedSlotDuration === '' ? 'selected' : '' }}>Sélectionner une durée</option>
                <option value="15" {{ $selectedSlotDuration == '15' ? 'selected' : '' }}>15 minutes</option>
                <option value="30" {{ $selectedSlotDuration == '30' ? 'selected' : '' }}>30 minutes</option>
                <option value="60" {{ $selectedSlotDuration == '60' ? 'selected' : '' }}>1 heure</option>
                <option value="120" {{ $selectedSlotDuration == '120' ? 'selected' : '' }}>2 heures</option>
            </x-select>
        </div>
    </x-card>

    <!-- Section Facturation -->
    <x-card>
        <x-slot name="header">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Paramètres de facturation</h3>
        </x-slot>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <x-input 
                name="invoice_prefix" 
                label="Préfixe de facture" 
                :value="old('invoice_prefix', $provider->billing_settings['invoice_prefix'] ?? '')" 
                placeholder="Ex: SP-"
                help="Ex: SP-001, SP-002..." />

            <x-input 
                type="number" 
                name="default_tax_rate" 
                label="Taux de taxe par défaut (%)" 
                :value="old('default_tax_rate', $provider->billing_settings['default_tax_rate'] ?? '')" 
                placeholder="Ex: 19"
                step="0.01"
                min="0"
                max="100" />

            <!-- Afficher matricule fiscal -->
            <div class="md:col-span-2">
                <div class="flex items-center">
                    <input type="checkbox" 
                           id="show_tax_id_on_invoice" 
                           name="show_tax_id_on_invoice" 
                           value="1"
                           {{ old('show_tax_id_on_invoice', $provider->billing_settings['show_tax_id_on_invoice'] ?? false) ? 'checked' : '' }}
                           class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 dark:border-gray-600 rounded">
                    <label for="show_tax_id_on_invoice" class="ml-3 text-sm font-medium text-gray-700 dark:text-gray-300">
                        Afficher le matricule fiscal sur les factures
                    </label>
                </div>
                @error('show_tax_id_on_invoice')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="md:col-span-2">
                <x-textarea 
                    name="invoice_footer" 
                    label="Texte de pied de facture" 
                    :value="old('invoice_footer', $provider->billing_settings['invoice_footer'] ?? '')" 
                    placeholder="Texte libre qui apparaîtra en bas de vos factures..."
                    rows="3" />
            </div>
        </div>
    </x-card>
    
    <!-- Bouton fixe au-dessus de la navigation du bas -->
    <div class="fixed bottom-16 left-0 right-0 p-4 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40">
        <x-button type="submit" variant="primary" class="w-full">
            Enregistrer les paramètres
        </x-button>
    </div>
</form>
@endsection
