@extends('layouts.provider')

@section('title', 'Fournisseurs')
@section('page-title', 'Finances')

@section('content')
<div class="space-y-6">
    <x-finances-tabs active="fournisseurs" />
    
    <x-card>
        <x-slot name="header">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Mes Fournisseurs ({{ $suppliers->count() }})</h3>
                <x-button href="{{ route('provider.suppliers.create') }}" size="sm">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Nouveau
                </x-button>
            </div>
        </x-slot>

        <div class="space-y-6">
            <!-- Filtres -->
            <form method="GET" class="flex flex-wrap gap-3 items-end">
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        name="search" 
                        label="Nom ou notes" 
                        :value="request('search')" 
                        placeholder="Rechercher..."
                    />
                </div>
                <div class="flex-1 min-w-[140px]">
                    <x-input 
                        name="phone" 
                        label="Téléphone" 
                        :value="request('phone')" 
                        placeholder="Numéro..."
                    />
                </div>
                <div class="flex gap-2 flex-shrink-0">
                    <x-button type="submit" class="h-10 px-3" title="Filtrer">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"></path>
                        </svg>
                    </x-button>
                    <x-button href="{{ route('provider.suppliers.index') }}" variant="secondary" class="h-10 px-3" title="Réinitialiser">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </x-button>
                </div>
            </form>

            @if($suppliers->count() > 0)
            <div class="space-y-3">
                @foreach($suppliers as $supplier)
                    <x-card class="hover:shadow-md transition-shadow {{ !$supplier->is_active ? 'opacity-60' : '' }}">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <h3 class="font-semibold text-gray-900 dark:text-white">
                                    {{ $supplier->name }}
                                    @if(!$supplier->is_active)
                                        <span class="ml-2 px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">Inactif</span>
                                    @endif
                                    @if($supplier->phone)
                                        <span class="text-xs font-normal text-gray-500 dark:text-gray-400"> · {{ $supplier->phone }}</span>
                                    @endif
                                </h3>
                                @if($supplier->email)
                                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $supplier->email }}</p>
                                @endif
                                @if($supplier->tax_id)
                                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">Matricule fiscal: {{ $supplier->tax_id }}</p>
                                @endif
                                @if($supplier->expenses_count > 0)
                                    <p class="text-xs text-blue-600 dark:text-blue-400 mt-1">Utilisé dans {{ $supplier->expenses_count }} dépense(s)</p>
                                @endif
                            </div>
                            <div class="flex space-x-2">
                                <x-button href="{{ route('provider.suppliers.edit', $supplier->uuid) }}" variant="secondary" size="sm">
                                    Éditer
                                </x-button>
                                @if($supplier->expenses_count == 0)
                                    <x-delete-confirm 
                                        :action="route('provider.suppliers.destroy', $supplier->uuid)" 
                                        message="Êtes-vous sûr de vouloir supprimer ce fournisseur ?"
                                    />
                                @endif
                            </div>
                        </div>
                    </x-card>
                @endforeach
            </div>
        @else
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">Aucun fournisseur</h3>
                <p class="mt-1 text-sm text-gray-500">Commencez par créer votre premier fournisseur.</p>
                <div class="mt-6">
                    <x-button href="{{ route('provider.suppliers.create') }}">
                        <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                        </svg>
                        Nouveau fournisseur
                    </x-button>
                </div>
            </div>
        @endif
    </x-card>
</div>
@endsection
