<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    if (auth()->user()->role === 'admin') {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('provider.dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin Routes
Route::middleware(['auth', 'active', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', function () {
        return view('admin.dashboard');
    })->name('dashboard');
    
    Route::get('/providers', [App\Http\Controllers\Admin\ProviderController::class, 'index'])->name('providers.index');
    Route::get('/providers/create', [App\Http\Controllers\Admin\ProviderController::class, 'create'])->name('providers.create');
    Route::post('/providers', [App\Http\Controllers\Admin\ProviderController::class, 'store'])->name('providers.store');
    Route::get('/providers/{uuid}/edit', [App\Http\Controllers\Admin\ProviderController::class, 'edit'])->name('providers.edit');
    Route::put('/providers/{uuid}', [App\Http\Controllers\Admin\ProviderController::class, 'update'])->name('providers.update');
    Route::delete('/providers/{uuid}', [App\Http\Controllers\Admin\ProviderController::class, 'destroy'])->name('providers.destroy');
});

// Provider Routes
Route::middleware(['auth', 'active', 'provider'])->prefix('provider')->name('provider.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [App\Http\Controllers\Provider\DashboardController::class, 'index'])->name('dashboard');
    
    // Finances
    Route::get('/finances', [App\Http\Controllers\Provider\FinancesController::class, 'index'])->name('finances.index');
    
    // Settings root (redirects to fiscal)
    Route::get('/settings', function () {
        return redirect()->route('provider.settings.fiscal.edit');
    })->name('settings.index');
    
    Route::get('/profile', [App\Http\Controllers\Provider\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [App\Http\Controllers\Provider\ProfileController::class, 'update'])->name('profile.update');
    
    // Client routes
    Route::get('/clients', [App\Http\Controllers\Provider\ClientController::class, 'index'])->name('clients.index');
    Route::get('/clients/create', [App\Http\Controllers\Provider\ClientController::class, 'create'])->name('clients.create');
    Route::post('/clients', [App\Http\Controllers\Provider\ClientController::class, 'store'])->name('clients.store');
    Route::get('/clients/{client_uuid}', [App\Http\Controllers\Provider\ClientController::class, 'show'])->name('clients.show');
    Route::get('/clients/{client_uuid}/edit', [App\Http\Controllers\Provider\ClientController::class, 'edit'])->name('clients.edit');
    Route::put('/clients/{client_uuid}', [App\Http\Controllers\Provider\ClientController::class, 'update'])->name('clients.update');
    Route::delete('/clients/{client_uuid}', [App\Http\Controllers\Provider\ClientController::class, 'destroy'])->name('clients.destroy');
    Route::post('/clients/{client_uuid}/restore', [App\Http\Controllers\Provider\ClientController::class, 'restore'])->name('clients.restore');
    
    // Service routes
    Route::get('/services', [App\Http\Controllers\Provider\ServiceController::class, 'index'])->name('services.index');
    Route::get('/services/create', [App\Http\Controllers\Provider\ServiceController::class, 'create'])->name('services.create');
    Route::post('/services', [App\Http\Controllers\Provider\ServiceController::class, 'store'])->name('services.store');
    Route::get('/services/{service_uuid}/edit', [App\Http\Controllers\Provider\ServiceController::class, 'edit'])->name('services.edit');
    Route::put('/services/{service_uuid}', [App\Http\Controllers\Provider\ServiceController::class, 'update'])->name('services.update');
    Route::delete('/services/{service_uuid}', [App\Http\Controllers\Provider\ServiceController::class, 'destroy'])->name('services.destroy');
    Route::post('/services/{service_uuid}/restore', [App\Http\Controllers\Provider\ServiceController::class, 'restore'])->name('services.restore');
    
    // Expense Type routes
    Route::get('/expense-types', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'index'])->name('expense-types.index');
    Route::get('/expense-types/create', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'create'])->name('expense-types.create');
    Route::post('/expense-types', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'store'])->name('expense-types.store');
    Route::get('/expense-types/{expense_type_uuid}/edit', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'edit'])->name('expense-types.edit');
    Route::put('/expense-types/{expense_type_uuid}', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'update'])->name('expense-types.update');
    Route::delete('/expense-types/{expense_type_uuid}', [App\Http\Controllers\Provider\ExpenseTypeController::class, 'destroy'])->name('expense-types.destroy');
    
    // Supplier routes
    Route::get('/suppliers', [App\Http\Controllers\Provider\SupplierController::class, 'index'])->name('suppliers.index');
    Route::get('/suppliers/create', [App\Http\Controllers\Provider\SupplierController::class, 'create'])->name('suppliers.create');
    Route::post('/suppliers', [App\Http\Controllers\Provider\SupplierController::class, 'store'])->name('suppliers.store');
    Route::get('/suppliers/{supplier_uuid}/edit', [App\Http\Controllers\Provider\SupplierController::class, 'edit'])->name('suppliers.edit');
    Route::put('/suppliers/{supplier_uuid}', [App\Http\Controllers\Provider\SupplierController::class, 'update'])->name('suppliers.update');
    Route::delete('/suppliers/{supplier_uuid}', [App\Http\Controllers\Provider\SupplierController::class, 'destroy'])->name('suppliers.destroy');
    
    // Expense routes (create/edit only - list is in finances)
    Route::get('/expenses/create', [App\Http\Controllers\Provider\ExpenseController::class, 'create'])->name('expenses.create');
    Route::post('/expenses', [App\Http\Controllers\Provider\ExpenseController::class, 'store'])->name('expenses.store');
    Route::get('/expenses/{expense_uuid}/edit', [App\Http\Controllers\Provider\ExpenseController::class, 'edit'])->name('expenses.edit');
    Route::put('/expenses/{expense_uuid}', [App\Http\Controllers\Provider\ExpenseController::class, 'update'])->name('expenses.update');
    Route::delete('/expenses/{expense_uuid}', [App\Http\Controllers\Provider\ExpenseController::class, 'destroy'])->name('expenses.destroy');
    
    // Settings routes
    Route::get('/settings/fiscal', [App\Http\Controllers\Provider\SettingsController::class, 'editFiscal'])->name('settings.fiscal.edit');
    Route::put('/settings/fiscal', [App\Http\Controllers\Provider\SettingsController::class, 'updateFiscal'])->name('settings.fiscal.update');
    Route::get('/settings/general', [App\Http\Controllers\Provider\SettingsController::class, 'editGeneral'])->name('settings.general.edit');
    Route::put('/settings/general', [App\Http\Controllers\Provider\SettingsController::class, 'updateGeneral'])->name('settings.general.update');
    
    // Calendar routes
    Route::get('/calendar', [App\Http\Controllers\CalendarController::class, 'index'])->name('calendar.index');
    Route::get('/calendar/appointments', [App\Http\Controllers\CalendarController::class, 'getAppointments'])->name('calendar.appointments');
    
    // Appointment routes
    Route::get('/appointments/calendar', [App\Http\Controllers\Provider\AppointmentController::class, 'calendar'])->name('appointments.calendar');
    Route::get('/appointments', [App\Http\Controllers\Provider\AppointmentController::class, 'index'])->name('appointments.index');
    Route::get('/appointments/create', [App\Http\Controllers\Provider\AppointmentController::class, 'create'])->name('appointments.create');
    Route::post('/appointments/check-overlap', [App\Http\Controllers\Provider\AppointmentController::class, 'checkOverlap'])->name('appointments.checkOverlap');
    Route::post('/appointments', [App\Http\Controllers\Provider\AppointmentController::class, 'store'])->name('appointments.store');
    Route::get('/appointments/{appointment_uuid}/edit', [App\Http\Controllers\Provider\AppointmentController::class, 'edit'])->name('appointments.edit');
    Route::put('/appointments/{appointment_uuid}', [App\Http\Controllers\Provider\AppointmentController::class, 'update'])->name('appointments.update');
    Route::delete('/appointments/{appointment_uuid}', [App\Http\Controllers\Provider\AppointmentController::class, 'destroy'])->name('appointments.destroy');
    
    // Payment routes (create/edit only - list is in finances)
    Route::get('/payments/create', [App\Http\Controllers\Provider\PaymentController::class, 'create'])->name('payments.create');
    Route::post('/payments', [App\Http\Controllers\Provider\PaymentController::class, 'store'])->name('payments.store');
    Route::get('/payments/{payment_uuid}/edit', [App\Http\Controllers\Provider\PaymentController::class, 'edit'])->name('payments.edit');
    Route::put('/payments/{payment_uuid}', [App\Http\Controllers\Provider\PaymentController::class, 'update'])->name('payments.update');
    Route::delete('/payments/{payment_uuid}', [App\Http\Controllers\Provider\PaymentController::class, 'destroy'])->name('payments.destroy');
    Route::get('/payments/{payment_uuid}/pdf', [App\Http\Controllers\Provider\PaymentController::class, 'pdf'])->name('payments.pdf');
    Route::get('/api/clients/{client_id}/appointments', [App\Http\Controllers\Provider\PaymentController::class, 'getClientAppointments'])->name('api.clients.appointments');
});

require __DIR__.'/auth.php';
