<?php $__env->startSection('title', 'Calendrier'); ?>
<?php $__env->startSection('page-title', 'Calendrier'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6 pb-20">
    <?php if (isset($component)) { $__componentOriginal53747ceb358d30c0105769f8471417f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53747ceb358d30c0105769f8471417f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.card','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
        <div class="max-w-2xl mx-auto">
                <!-- Header -->
                <div class="text-center py-6">
                    <div class="flex items-center justify-center gap-4 mb-4">
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Calendrier</h1>
                        <a href="<?php echo e(route('provider.appointments.index')); ?>" class="text-sm text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="inline-flex rounded-lg bg-gray-100 p-1 dark:bg-gray-800">
                        <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $date, 'view' => 'day'])); ?>" 
                           class="inline-flex items-center rounded-md px-4 py-2 text-sm font-medium transition-colors <?php echo e($view === 'day' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/10 dark:text-white' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'); ?>">
                            Jour
                        </a>
                        <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $date, 'view' => 'month'])); ?>" 
                           class="inline-flex items-center rounded-md px-4 py-2 text-sm font-medium transition-colors <?php echo e($view === 'month' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/10 dark:text-white' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'); ?>">
                            Mois
                        </a>
                        <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $date, 'view' => 'year'])); ?>" 
                           class="inline-flex items-center rounded-md px-4 py-2 text-sm font-medium transition-colors <?php echo e($view === 'year' ? 'bg-white text-gray-900 shadow-sm dark:bg-white/10 dark:text-white' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'); ?>">
                            Année
                        </a>
                    </div>
                </div>

    <?php
        $months = ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'];
        $selectedDate = now()->parse($date);
    ?>
    
    <?php if($view === 'month'): ?>
        <!-- Month Navigation -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm p-4 mb-4">
            <div class="flex items-center justify-between">
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->startOfMonth()->subMonth()->format('Y-m-d'), 'view' => 'month'])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">
                    <?php echo e($months[(int)now()->parse($date)->format('n') - 1]); ?> <?php echo e(now()->parse($date)->format('Y')); ?>

                </h2>
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->startOfMonth()->addMonth()->format('Y-m-d'), 'view' => 'month'])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
            </div>
        </div>
    <?php elseif($view === 'year'): ?>
        <!-- Year Navigation -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm p-4 mb-4">
            <div class="flex items-center gap-4">
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->subYear()->format('Y-m-d'), 'view' => 'year'])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-lg">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <select onchange="window.location.href=this.value" class="flex-1 px-4 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white rounded-lg focus:ring-2 focus:ring-blue-500">
                    <?php
                        $currentYear = (int)now()->parse($date)->format('Y');
                        $firstAppt = auth()->user()->provider->appointments()->orderBy('start_time')->first();
                        $startYear = $firstAppt ? (int)$firstAppt->start_time->format('Y') : $currentYear;
                        $endYear = $currentYear + 1;
                    ?>
                    <?php for($y = $startYear; $y <= $endYear; $y++): ?>
                        <?php
                            $yearDate = now()->parse($date)->year($y)->startOfYear();
                        ?>
                        <option value="<?php echo e(route('provider.appointments.calendar', ['date' => $yearDate->format('Y-m-d'), 'view' => 'year'])); ?>" <?php echo e($y === $currentYear ? 'selected' : ''); ?>>
                            <?php echo e($y); ?>

                        </option>
                    <?php endfor; ?>
                </select>
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->addYear()->format('Y-m-d'), 'view' => 'year'])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-lg">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
            </div>
        </div>
    <?php else: ?>
        <!-- Week Calendar -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm p-4 mb-4">
            <div class="flex items-center justify-between mb-4">
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->subWeek()->format('Y-m-d')])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <h2 class="text-base font-semibold text-gray-900 dark:text-white">
                    <?php
                        $monthIndex = (int)now()->parse($date)->format('n') - 1;
                    ?>
                    <?php echo e($months[$monthIndex]); ?> <?php echo e(now()->parse($date)->format('Y')); ?>

                </h2>
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->parse($date)->addWeek()->format('Y-m-d')])); ?>" 
                   class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                    <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
            </div>

            <?php
                $startOfWeek = $selectedDate->copy()->startOfWeek();
                $daysOfWeek = ['L', 'M', 'M', 'J', 'V', 'S', 'D'];
            ?>

            <!-- 7 Days Week View -->
            <div class="grid grid-cols-7 gap-2 mb-2">
                <?php for($i = 0; $i < 7; $i++): ?>
                    <?php
                        $day = $startOfWeek->copy()->addDays($i);
                        $isSelected = $day->format('Y-m-d') === $selectedDate->format('Y-m-d');
                        $isToday = $day->isToday();
                        $dayAppointments = $appointments->filter(fn($apt) => $apt->start_time->format('Y-m-d') === $day->format('Y-m-d'));
                        $hasAppointments = $dayAppointments->count() > 0;
                    ?>
                    <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $day->format('Y-m-d')])); ?>" 
                       class="flex flex-col items-center py-3 rounded-lg transition-all relative
                              <?php echo e($isSelected ? 'bg-primary text-white shadow-sm' : 'hover:bg-gray-100 dark:hover:bg-gray-700'); ?>">
                        <?php if($isToday && !$isSelected): ?>
                            <span class="absolute top-1 w-2 h-2 bg-blue-600 rounded-full"></span>
                        <?php endif; ?>
                        <span class="text-xs font-medium mb-1 <?php echo e($isSelected ? 'text-white' : 'text-gray-500 dark:text-gray-400'); ?>">
                            <?php echo e($daysOfWeek[$i]); ?>

                        </span>
                        <span class="text-lg font-semibold <?php echo e($isSelected ? 'text-white' : 'text-gray-900 dark:text-white'); ?>">
                            <?php echo e($day->format('d')); ?>

                        </span>
                        <?php if($hasAppointments && !$isSelected): ?>
                            <span class="w-1 h-1 bg-blue-600 rounded-full mt-1"></span>
                        <?php endif; ?>
                    </a>
                <?php endfor; ?>
            </div>
            <?php if($view === 'day' && $selectedDate->format('Y-m-d') !== now()->format('Y-m-d')): ?>
            <div class="mt-2">
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => now()->format('Y-m-d'), 'view' => $view])); ?>" class="text-xs text-gray-600 dark:text-gray-400 hover:text-primary underline transition-colors">
                    <?php
                        $today = now();
                        $daysLong = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
                        $dayOfWeek = $daysLong[$today->dayOfWeek];
                        $monthIndex = (int)$today->format('n') - 1;
                    ?>
                    Aujourd'hui, <?php echo e($dayOfWeek); ?>, <?php echo e($today->format('d')); ?> <?php echo e($months[$monthIndex]); ?> <?php echo e($today->format('Y')); ?>

                </a>
            </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Selected Date -->
    <?php if($view !== 'month'): ?>
        <div class="text-center mb-4">
            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">
                <?php
                    $daysLong = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
                    $dayOfWeek = $daysLong[$selectedDate->dayOfWeek];
                    $monthIndex = (int)$selectedDate->format('n') - 1;
                ?>
                <?php echo e($dayOfWeek); ?>, <?php echo e($selectedDate->format('d')); ?> <?php echo e($months[$monthIndex]); ?> <?php echo e($selectedDate->format('Y')); ?>

            </h3>
        </div>
    <?php endif; ?>

    <?php if($view === 'year'): ?>
        <!-- Year View - 12 Months Grid -->
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            <?php for($m = 1; $m <= 12; $m++): ?>
                <?php
                    $monthDate = now()->parse($date)->month($m)->startOfMonth();
                    $monthEnd = $monthDate->copy()->endOfMonth();
                    $monthAppts = $appointments->filter(function($apt) use ($monthDate, $monthEnd) {
                        return $apt->start_time->between($monthDate, $monthEnd);
                    });
                    $total = $monthAppts->count();
                ?>
                <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $monthDate->format('Y-m-d'), 'view' => 'month'])); ?>"
                   class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-4 hover:shadow-md hover:border-primary transition-all">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3"><?php echo e($months[$m - 1]); ?></h3>
                    <div class="text-2xl font-bold text-blue-600"><?php echo e($total); ?> RDV</div>
                </a>
            <?php endfor; ?>
        </div>
    <?php elseif($view === 'month'): ?>
        <!-- Monthly Calendar View -->
        <?php
            $currentMonth = now()->parse($date);
            $startOfMonth = $currentMonth->copy()->startOfMonth();
            $endOfMonth = $currentMonth->copy()->endOfMonth();
            $startDate = $startOfMonth->copy()->startOfWeek();
            $endDate = $endOfMonth->copy()->endOfWeek();
        ?>
        
        <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-4">
            <!-- Days of week header -->
            <div class="grid grid-cols-7 gap-2 mb-2">
                <?php $__currentLoopData = ['Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam', 'Dim']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-center text-xs font-semibold text-gray-600 dark:text-gray-400"><?php echo e($day); ?></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Calendar grid -->
            <div class="grid grid-cols-7 gap-2">
                <?php
                    $currentDay = $startDate->copy();
                ?>
                <?php while($currentDay->lte($endDate)): ?>
                    <?php
                        $dayStr = $currentDay->format('Y-m-d');
                        $isCurrentMonth = $currentDay->month === $currentMonth->month && $currentDay->year === $currentMonth->year;
                        $isToday = $currentDay->isToday();
                        $dayAppts = $appointments->filter(fn($apt) => $apt->start_time->format('Y-m-d') === $dayStr);
                    ?>
                    
                    <a href="<?php echo e(route('provider.appointments.calendar', ['date' => $dayStr, 'view' => 'day'])); ?>"
                       class="border rounded-lg p-2 min-h-20 <?php echo e($isCurrentMonth ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900'); ?> <?php echo e($isToday ? 'border-primary border-2' : 'border-gray-200 dark:border-gray-700'); ?> hover:border-primary hover:shadow-sm transition-all">
                        <div class="text-sm font-semibold <?php echo e($isCurrentMonth ? 'text-gray-900 dark:text-white' : 'text-gray-400 dark:text-gray-600'); ?> mb-1">
                            <?php echo e($currentDay->format('d')); ?>

                        </div>
                        <?php if($dayAppts->count() > 0): ?>
                            <div class="text-xs text-blue-600 font-medium"><?php echo e($dayAppts->count()); ?> RDV</div>
                        <?php endif; ?>
                    </a>
                    <?php
                        $currentDay->addDay();
                    ?>
                <?php endwhile; ?>
            </div>
        </div>
    <?php else: ?>
        <!-- Time Slots with Appointments -->
        <div class="space-y-1">
        <?php
            $dayAppointments = $appointments->filter(fn($apt) => $apt->start_time->format('Y-m-d') === $selectedDate->format('Y-m-d'));
            $statusColors = [
                'scheduled' => ['text' => 'text-blue-600', 'label' => 'PLANIFIÉ'],
                'in_progress' => ['text' => 'text-orange-600', 'label' => 'EN COURS'],
                'completed' => ['text' => 'text-green-600', 'label' => 'TERMINÉ'],
                'canceled' => ['text' => 'text-red-600', 'label' => 'ANNULÉ'],
            ];
            
            $occupiedSlots = [];
            $hourSlots = [];
            
            foreach($dayAppointments as $apt) {
                $startHour = (int)$apt->start_time->format('H');
                $occupiedSlots[$startHour] = $apt;
                
                $startMinutes = $apt->start_time->hour * 60 + $apt->start_time->minute;
                $endMinutes = $apt->end_time->hour * 60 + $apt->end_time->minute;
                
                for($m = $startMinutes; $m < $endMinutes; $m += 15) {
                    $h = floor($m / 60);
                    $min = $m % 60;
                    if(!isset($hourSlots[$h])) $hourSlots[$h] = [];
                    $hourSlots[$h][$min] = $apt;
                }
            }
        ?>

        <?php for($hour = 6; $hour <= 20; $hour++): ?>
            <?php
                $timeLabel = sprintf('%dh', $hour);
                $slots = $hourSlots[$hour] ?? [];
                $hasOccupied = count($slots) > 0;
            ?>
            
            <?php if($hasOccupied): ?>
                    <?php
                        $firstSlot = reset($slots);
                    ?>
                    <!-- Heure partiellement occupée -->
                    <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 border-l-4 border-l-primary rounded-lg shadow-sm">
                        <div class="p-3">
                            <div class="flex items-center gap-2">
                                <div class="text-base font-semibold text-gray-900 dark:text-white w-12 flex items-center justify-center"><?php echo e($timeLabel); ?></div>
                                <div class="flex-1 flex gap-2">
                                    <?php
                                        $minutes = [0, 15, 30, 45];
                                        $i = 0;
                                    ?>
                                    <?php while($i < count($minutes)): ?>
                                        <?php
                                            $min = $minutes[$i];
                                            $isOccupied = isset($slots[$min]);
                                            $timeSlot = sprintf('%02d:%02d', $hour, $min);
                                            $apt = $slots[$min] ?? null;
                                            
                                            if($isOccupied && $apt) {
                                                $span = 1;
                                                for($j = $i + 1; $j < count($minutes); $j++) {
                                                    $nextMin = $minutes[$j];
                                                    $nextApt = $slots[$nextMin] ?? null;
                                                    if($nextApt && $nextApt->id === $apt->id) {
                                                        $span++;
                                                    } else {
                                                        break;
                                                    }
                                                }
                                                $status = $statusColors[$apt->status] ?? $statusColors['scheduled'];
                                            }
                                        ?>
                                        <?php if($isOccupied && $apt): ?>
                                            <a href="<?php echo e(route('provider.appointments.edit', $apt->uuid)); ?>" 
                                               id="apt-<?php echo e($apt->uuid); ?>"
                                               class="rounded p-2 relative cursor-pointer hover:bg-gray-300 dark:hover:bg-gray-600 transition-all <?php echo e(request('highlight') === $apt->uuid ? 'bg-yellow-200 border-2 border-yellow-400 animate-pulse' : 'bg-gray-200 dark:bg-gray-600'); ?>" style="flex: <?php echo e($span); ?>">
                                                <?php if($apt->payments && $apt->payments->count() > 0): ?>
                                                    <div class="absolute top-0 right-0 w-0 h-0 border-t-[12px] border-t-green-400 border-l-[12px] border-l-transparent rounded-tr"></div>
                                                <?php endif; ?>
                                                <div class="flex items-center justify-between mb-1">
                                                    <div class="text-xs text-gray-700 dark:text-gray-300 font-medium"><?php echo e($apt->start_time->format('H\hi')); ?> - <?php echo e($apt->end_time->format('H\hi')); ?></div>
                                                    <span class="text-xs font-bold <?php echo e($status['text']); ?>"><?php echo e($status['label']); ?></span>
                                                </div>
                                                <div class="flex items-center gap-2 mb-2">
                                                    <?php if($apt->service && $apt->service->color): ?>
                                                        <div class="w-3 h-3 rounded-full flex-shrink-0" style="background-color: <?php echo e($apt->service->color); ?>"></div>
                                                    <?php endif; ?>
                                                    <div class="text-sm font-semibold text-gray-900 dark:text-white"><?php echo e($apt->service ? $apt->service->name : 'Rendez-vous'); ?></div>
                                                </div>
                                                <?php if($apt->client): ?>
                                                    <div class="flex items-center gap-1">
                                                        <div class="w-5 h-5 rounded-full bg-blue-100 flex items-center justify-center flex-shrink-0">
                                                            <span class="text-xs font-semibold text-blue-600">
                                                                <?php echo e(strtoupper(substr($apt->client->first_name, 0, 1) . substr($apt->client->last_name, 0, 1))); ?>

                                                            </span>
                                                        </div>
                                                        <span class="text-xs text-gray-700 dark:text-gray-300 truncate"><?php echo e($apt->client->full_name); ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            </a>
                                            <?php
                                                $i += $span;
                                            ?>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('provider.appointments.create', ['date' => $selectedDate->format('Y-m-d'), 'time' => $timeSlot])); ?>"
                                               class="flex-1 bg-blue-50 dark:bg-blue-900/30 hover:bg-blue-100 dark:hover:bg-blue-900/50 rounded p-2 flex items-center justify-center transition-colors">
                                                <span class="text-xs text-blue-600 dark:text-blue-400 font-medium"><?php echo e($hour); ?>h<?php echo e(str_pad($min, 2, '0', STR_PAD_LEFT)); ?></span>
                                            </a>
                                            <?php
                                                $i++;
                                            ?>
                                        <?php endif; ?>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Créneau complètement libre -->
                    <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 border-l-4 border-l-gray-300 dark:border-l-gray-600 rounded-lg shadow-sm">
                        <div class="p-3">
                            <div class="flex items-center gap-2">
                                <div class="text-base font-semibold text-gray-900 dark:text-white w-12 flex items-center justify-center"><?php echo e($timeLabel); ?></div>
                                <div class="flex-1 flex gap-2">
                                    <?php $__currentLoopData = [0, 15, 30, 45]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $min): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $timeSlot = sprintf('%02d:%02d', $hour, $min);
                                        ?>
                                        <a href="<?php echo e(route('provider.appointments.create', ['date' => $selectedDate->format('Y-m-d'), 'time' => $timeSlot])); ?>"
                                           class="flex-1 bg-blue-50 dark:bg-blue-900/30 hover:bg-blue-100 dark:hover:bg-blue-900/50 rounded p-2 flex items-center justify-center transition-colors">
                                            <span class="text-xs text-blue-600 dark:text-blue-400 font-medium"><?php echo e($hour); ?>h<?php echo e(str_pad($min, 2, '0', STR_PAD_LEFT)); ?></span>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
        <?php endfor; ?>
        </div>
        
        <!-- Légende -->
        <div class="mt-4 p-3 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg">
            <div class="flex items-center gap-2 text-xs text-gray-600 dark:text-gray-400">
                <div class="w-4 h-4 bg-gray-200 dark:bg-gray-600 rounded relative">
                    <div class="absolute top-0 right-0 w-0 h-0 border-t-[8px] border-t-green-400 border-l-[8px] border-l-transparent rounded-tr"></div>
                </div>
                <span>Séance facturée</span>
            </div>
        </div>
    <?php endif; ?>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53747ceb358d30c0105769f8471417f6)): ?>
<?php $attributes = $__attributesOriginal53747ceb358d30c0105769f8471417f6; ?>
<?php unset($__attributesOriginal53747ceb358d30c0105769f8471417f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53747ceb358d30c0105769f8471417f6)): ?>
<?php $component = $__componentOriginal53747ceb358d30c0105769f8471417f6; ?>
<?php unset($__componentOriginal53747ceb358d30c0105769f8471417f6); ?>
<?php endif; ?>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php if(request('highlight')): ?>
            const highlightedUuid = '<?php echo e(request('highlight')); ?>';
            const elements = document.querySelectorAll('[id="apt-' + highlightedUuid + '"]');
            
            if (elements.length > 0) {
                elements[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
                
                setTimeout(() => {
                    elements.forEach(element => {
                        element.classList.remove('bg-yellow-200', 'border-2', 'border-yellow-400', 'animate-pulse');
                        element.classList.add('bg-gray-200');
                    });
                    
                    const url = new URL(window.location);
                    url.searchParams.delete('highlight');
                    window.history.replaceState({}, '', url);
                }, 1000);
            }
        <?php else: ?>
            const selectedDate = '<?php echo e($date); ?>';
            const today = new Date().toISOString().split('T')[0];
            
            if (selectedDate === today && '<?php echo e($view); ?>' === 'day') {
                const now = new Date();
                const currentHour = now.getHours();
                
                if (currentHour >= 6 && currentHour <= 20) {
                    const timeSlots = document.querySelectorAll('.space-y-1 > div');
                    const targetIndex = currentHour - 6;
                    
                    if (timeSlots[targetIndex]) {
                        setTimeout(() => {
                            timeSlots[targetIndex].scrollIntoView({ behavior: 'smooth', block: 'center' });
                        }, 300);
                    }
                }
            }
        <?php endif; ?>
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.provider', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\laravel\resources\views/provider/appointments/calendar.blade.php ENDPATH**/ ?>