<div>
    <label class="mb-1.5 block text-sm font-medium text-gray-700 dark:text-gray-400">
        Multiple Select Options
    </label>

    <div x-data="{
        open: false,
        selected: [1, 3],
        options: [
            { id: 1, name: 'Option 1' },
            { id: 2, name: 'Option 2' },
            { id: 3, name: 'Option 3' },
            { id: 4, name: 'Option 4' },
            { id: 5, name: 'Option 5' }
        ],
        toggleOption(id) {
            if (this.selected.includes(id)) {
                this.selected = this.selected.filter(i => i !== id);
            } else {
                this.selected.push(id);
            }
        },
        isSelected(id) {
            return this.selected.includes(id);
        }
    }" class="relative" @click.away="open = false">
        <!-- Hidden input for form submission -->
        <input type="hidden" name="selected_options" :value="selected.join(',')" />

        <!-- Select Input with Selected Tags -->
        <div @click="open = !open"
            class="shadow-theme-xs flex min-h-11 cursor-pointer gap-2 rounded-lg border border-gray-300 bg-white px-3 py-2 transition dark:border-gray-700 dark:bg-gray-900">
            <!-- Selected Items as Tags -->
            <div class="flex flex-1 flex-wrap items-center gap-2">
                <template x-for="id in selected" :key="id">
                    <div
                        class="group flex items-center justify-center rounded-full border-[0.7px] border-transparent bg-gray-100 py-1 pr-2 pl-2.5 text-sm text-gray-800 hover:border-gray-200 dark:bg-gray-800 dark:text-white/90 dark:hover:border-gray-800">
                        <span x-text="options.find(o => o.id === id).name"></span>
                        <button type="button" @click.stop="toggleOption(id)"
                            class="ml-1 text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                            <svg class="fill-current" role="button" width="14" height="14" viewBox="0 0 14 14"
                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M3.40717 4.46881C3.11428 4.17591 3.11428 3.70104 3.40717 3.40815C3.70006 3.11525 4.17494 3.11525 4.46783 3.40815L6.99943 5.93975L9.53095 3.40822C9.82385 3.11533 10.2987 3.11533 10.5916 3.40822C10.8845 3.70112 10.8845 4.17599 10.5916 4.46888L8.06009 7.00041L10.5916 9.53193C10.8845 9.82482 10.8845 10.2997 10.5916 10.5926C10.2987 10.8855 9.82385 10.8855 9.53095 10.5926L6.99943 8.06107L4.46783 10.5927C4.17494 10.8856 3.70006 10.8856 3.40717 10.5927C3.11428 10.2998 3.11428 9.8249 3.40717 9.53201L5.93877 7.00041L3.40717 4.46881Z"
                                    fill="" />
                            </svg>
                        </button>
                    </div>
                </template>

                <!-- Show placeholder when nothing is selected -->
                <span x-show="selected.length === 0" class="text-sm text-gray-500 dark:text-gray-400">
                    Select options...
                </span>
            </div>

            <!-- Dropdown Arrow -->
            <div class="flex items-start pt-1.5">
                <svg class="h-5 w-5 shrink-0 text-gray-500 transition-transform dark:text-gray-400"
                    :class="open ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                </svg>
            </div>
        </div>

        <!-- Dropdown Options List -->
        <div x-show="open"
            class="absolute z-50 mt-1 w-full overflow-hidden rounded-lg border border-gray-200 bg-white dark:border-gray-700 dark:bg-gray-900"
            style="max-height: 16rem">
            <div class="overflow-y-auto" style="max-height: 16rem">
                <template x-for="option in options" :key="option.id">
                    <div @click="toggleOption(option.id)"
                        class="cursor-pointer border-b border-gray-200 px-4 py-3 text-sm transition last:border-b-0 dark:border-gray-800">
                        <span class="text-gray-800 dark:text-white/90" x-text="option.name"></span>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div>
