@extends('layouts.app')

@php
    use Illuminate\Support\HtmlString;

    // Page title
    $currentPageTitle = 'Buttons';

    // Define BoxIcon once as an HtmlString (so it won’t get escaped)
    $BoxIcon = new HtmlString('
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M9.77692 3.24224C9.91768 3.17186 10.0834 3.17186 10.2241 3.24224L15.3713 5.81573L10.3359 8.33331C10.1248 8.43888 9.87626 8.43888 9.66512 8.33331L4.6298 5.81573L9.77692 3.24224ZM3.70264 7.0292V13.4124C3.70264 13.6018 3.80964 13.775 3.97903 13.8597L9.25016 16.4952L9.25016 9.7837C9.16327 9.75296 9.07782 9.71671 8.99432 9.67496L3.70264 7.0292ZM10.7502 16.4955V9.78396C10.8373 9.75316 10.923 9.71683 11.0067 9.67496L16.2984 7.0292V13.4124C16.2984 13.6018 16.1914 13.775 16.022 13.8597L10.7502 16.4955ZM9.41463 17.4831L9.10612 18.1002C9.66916 18.3817 10.3319 18.3817 10.8949 18.1002L16.6928 15.2013C17.3704 14.8625 17.7984 14.17 17.7984 13.4124V6.58831C17.7984 5.83076 17.3704 5.13823 16.6928 4.79945L10.8949 1.90059C10.3319 1.61908 9.66916 1.61907 9.10612 1.90059L9.44152 2.57141L9.10612 1.90059L3.30823 4.79945C2.63065 5.13823 2.20264 5.83076 2.20264 6.58831V13.4124C2.20264 14.17 2.63065 14.8625 3.30823 15.2013L9.10612 18.1002L9.41463 17.4831Z"
                fill="currentColor"
            />
        </svg>
    ');
@endphp

@section('content')
    {{-- Page Breadcrumb --}}
    <x-common.page-breadcrumb :pageTitle="$currentPageTitle" />

    <div class="space-y-5 sm:space-y-6">

        {{-- Primary Buttons --}}
        <x-common.component-card title="Primary Button">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="primary">Button Text</x-ui.button>
                <x-ui.button size="md" variant="primary">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

        {{-- Primary Button with Left Icon --}}
        <x-common.component-card title="Primary Button with Left Icon">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="primary" :startIcon="$BoxIcon">Button Text</x-ui.button>
                <x-ui.button size="md" variant="primary" :startIcon="$BoxIcon">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

        {{-- Primary Button with Right Icon --}}
        <x-common.component-card title="Primary Button with Right Icon">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="primary" :endIcon="$BoxIcon">Button Text</x-ui.button>
                <x-ui.button size="md" variant="primary" :endIcon="$BoxIcon">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

        {{-- Outline Buttons --}}
        <x-common.component-card title="Outline Button">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="outline">Button Text</x-ui.button>
                <x-ui.button size="md" variant="outline">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

        {{-- Outline Button with Left Icon --}}
        <x-common.component-card title="Outline Button with Left Icon">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="outline" :startIcon="$BoxIcon">Button Text</x-ui.button>
                <x-ui.button size="md" variant="outline" :startIcon="$BoxIcon">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

        {{-- Outline Button with Right Icon --}}
        <x-common.component-card title="Outline Button with Right Icon">
            <div class="flex items-center gap-5">
                <x-ui.button size="sm" variant="outline" :endIcon="$BoxIcon">Button Text</x-ui.button>
                <x-ui.button size="md" variant="outline" :endIcon="$BoxIcon">Button Text</x-ui.button>
            </div>
        </x-common.component-card>

    </div>
@endsection
