import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    darkMode: 'class',

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                primary: {
                    DEFAULT: '#3C50E0',
                    50: '#F0F2FF',
                    100: '#E1E7FF',
                    500: '#3C50E0',
                    600: '#2A3BB7',
                    700: '#1E2B8A',
                },
                secondary: '#80CAEE',
            },
        },
    },

    plugins: [forms],
};
